@extends('admin.layout.base')
@section('content')
<div class="content-container">
    <div class="form-container">
      <h2 class="page-heading">Add User</h2>
      <form id="userForm">
        @csrf
        <div class="two-col-form">
          <div>
            <label for="full_name">Full Name</label>
            <input
              type="text"
              name="full_name"
              id="full_name"
              placeholder="Full Name"
              required
            />
          </div>
          <div>
            <label for="email">Email</label>
            <input
              type="email"
              name="email"
              id="email"
              placeholder="Email"
              required
            />
          </div>
        </div>
        <div class="two-col-form">
          <div>
            <label for="phone">Phone no</label>
            <input
              type="text"
              name="phone"
              id="phone"
              placeholder="Phone no"
              required
            />
          </div>
          <div>
            <label for="password">Password</label>
            <input type="password" placeholder="Password" name="password" id="password" required />
          </div>
        </div>
        <input type="submit" class="form-submit-button" value="Add User">
      </form>

      <!-- Success/Error Messages -->
      <div id="message" style="margin-top: 15px;"></div>

    </div>
  </div>
</div>

@endsection

@push('js')

<script>
  
$(document).ready(function() {
    $("#userForm").submit(function(event) {
        event.preventDefault(); // Prevent default form submission

        let formData = {
            fullname: $("#full_name").val(),
            email: $("#email").val(),
            phone: $("#phone").val(),
            password: $("#password").val(),
        };

        $.ajax({
            url: "{{ url('/api/users') }}", // API endpoint
            type: "POST",
            data: JSON.stringify(formData),
            contentType: "application/json",
            headers: {
                "X-CSRF-TOKEN": "{{ csrf_token() }}" // CSRF token for security
            },
            success: function(response) {
                $("#message").html('<p style="color: green;">User added successfully!</p>');
                $("#userForm")[0].reset(); // Reset form fields
            },
            error: function(xhr) {
                let errorMessage = xhr.responseJSON ? xhr.responseJSON.message : "Error occurred!";
                $("#message").html('<p style="color: red;">' + errorMessage + '</p>');
            }
        });
    });
});
</script>
@endpush