@extends('admin.layout.base')

@section('content')
<div class="content-container">
    <div class="form-container">
        <h2 class="page-heading">Update Profile</h2>
        <form id="profileForm">
            <div class="two-col-form">
                <div>
                    <label for="email">Email</label>
                    <input 
                        type="email" 
                        name="email" 
                        id="email" 
                        placeholder="Enter new email" 
                        value="{{ auth()->user()->email }}" 
                        required
                    />
                </div>
                <div>
                    <label for="password">New Password <small>(Leave blank to keep current)</small></label>
                    <input 
                        type="password" 
                        name="password" 
                        id="password" 
                        placeholder="New Password"
                    />
                </div>
            </div>

            <div class="two-col-form">
                <div>
                    <label for="password_confirmation">Confirm New Password</label>
                    <input 
                        type="password" 
                        name="password_confirmation" 
                        id="password_confirmation" 
                        placeholder="Confirm Password"
                    />
                </div>
            </div>

            <input type="submit" class="form-submit-button" value="Update Profile">
        </form>
    </div>
</div>
@endsection

@push('js')
<script>
$(document).ready(function () {
    const APP_REDIRECT_URL = "{{ $APP_REDIRECT_URL }}";
    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
    const adminToken = '{{ session('admin_api_token') }}';

    $('#profileForm').on('submit', function (e) {
        e.preventDefault();

        const formData = {
            email: $('#email').val(),
            password: $('#password').val(),
            password_confirmation: $('#password_confirmation').val()
        };

        $.ajax({
            url: `${APP_REDIRECT_URL}/profile/update`,
            type: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': csrfToken,
                'Accept': 'application/json',
                ...(adminToken && { 'Authorization': `Bearer ${adminToken}` })
            },
            success: function (response) {
                alert('Profile updated.Please Login Again...');
                window.location.href = "/login"; 
       
            },
            error: function (xhr) {
                const errorMessage = xhr.responseJSON?.message || 'Something went wrong.';
                alert('Error: ' + errorMessage);
            }
        });
    });
});
</script>
@endpush
