@extends('admin.layout.base')

@push('styles')
<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/2.2.2/css/dataTables.dataTables.min.css">
@endpush

@section('content')
<div class="content-container">
    <div class="table-container">
        <table id="usersTable" class="display">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Email</th>
                    <th>OverAll Level</th>
                </tr>
            </thead>
            <tbody>
                <!-- Data will be inserted here via AJAX -->
            </tbody>
        </table>
    </div>
</div>
@endsection

@push('js')
<!-- DataTables JS -->
<script src="https://cdn.datatables.net/2.2.2/js/dataTables.min.js"></script>

<script>
$(document).ready(function() {
    const API_BASE_URL = "{{ $API_BASE_URL }}";
const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
const adminToken = '{{ session('admin_api_token') }}';

$(document).ready(function() {
    $('#usersTable').DataTable({
        processing: true,
        serverSide: false,
        ajax: {
            url: `${API_BASE_URL}/users`,
            type: "GET",
            dataSrc: "",
            beforeSend: function(xhr) {
                xhr.setRequestHeader('Accept', 'application/json');
                xhr.setRequestHeader('X-CSRF-TOKEN', csrfToken);
                if (adminToken) {
                    xhr.setRequestHeader('Authorization', `Bearer ${adminToken}`);
                }
            }
        },
        columns: [
            { data: "fullname" },
            { data: "email" },
            { data: "overall_level" },
            {
            data: "status",
            render: function(data, type, row) {
                const btnClass = data === 'active' ? 'btn-success' : 'btn-danger';
                const label = data === 'active' ? 'Active' : 'Inactive';
                return `
                    <button class="toggle-status-btn ${btnClass}" data-id="${row.id}">
                        ${label}
                    </button>
                `;
            }
             },
        ]
    });

    // Handle status toggle
    $('#usersTable tbody').on('click', '.toggle-status-btn', function() {
            const userId = $(this).data('id');
             // Show confirmation prompt
            if (!confirm("Are you sure you want to change the user's status?")) {
                return; // Stop if user cancels
            }
            
            $.ajax({
                url: `${API_BASE_URL}/change/status/user/${userId}`,
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': csrfToken,
                    'Accept': 'application/json',
                    ...(adminToken && { 'Authorization': `Bearer ${adminToken}` })
                },
                success: function(response) {
                    alert(response.message);
                    $('#usersTable').DataTable().ajax.reload();
                },
                error: function(xhr) {
                    alert('Error changing status');
                    console.error(xhr.responseJSON || xhr);
                }
            });
        });
});



});
</script>
@endpush
