<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AdminController\AuthController;
use App\Http\Controllers\AdminController\UserController;
use App\Http\Controllers\AdminController\BannerController;
use App\Http\Controllers\AdminController\NotificationController;
use App\Http\Controllers\AdminController\PopupController;




Route::get('/', function () {
    return redirect()->route('login');
});

// Public routes
Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [AuthController::class, 'loginWeb'])->name('admin.login.submit');
Route::get('/logout', [AuthController::class, 'logout'])->name('admin.logout');

// Protected routes
Route::middleware(['auth'])->group(function () {
    Route::get('/dashboard', [AuthController::class, 'dashboard'])->name('admin.dashboard');
    Route::get('/profile/settings', [AuthController::class, 'showProfile'])->name('admin.profile');
    Route::post('/profile/update', [AuthController::class, 'updateProfile']);

    // Users
    Route::get('/users', [UserController::class, 'index'])->name('users');
    Route::get('/user/add', [UserController::class, 'add'])->name('users.add');

    // Banners
    Route::get('/banners', [BannerController::class, 'index'])->name('banners');
    Route::get('/banner/add', [BannerController::class, 'add'])->name('banners.add');

    // Notifications
    Route::get('/notifications', [NotificationController::class, 'index'])->name('notifications');
    Route::get('/notifications/add', [NotificationController::class, 'add'])->name('notifications.add');

    // Popups
    Route::get('/popups', [PopupController::class, 'index'])->name('popup');
    Route::get('/popups/add', [PopupController::class, 'add'])->name('popup.add');
});