

<?php $__env->startSection('content'); ?>
<div class="content-container">
    <div class="form-container">
        <h2 class="page-heading">Add Banner</h2>
        <form id="bannerForm" enctype="multipart/form-data">
            <div class="two-col-form">
                <div>
                    <label for="banner_duration">Banner Duration (Days)</label>
                    <input type="number" name="banner_duration" id="banner_duration" placeholder="Duration" />
                </div>
                <div>
                    <label for="expire_date">Expire Date</label>
                    <input type="date" name="expire_date" id="expire_date" placeholder="Expire Date" />
                </div>
            </div>

            <div class="two-col-form">
                <div>
                    <label for="title">Title</label>
                    <input type="text" name="title" id="title" placeholder="Main Title" />
                </div>
                <div>
                    <label for="sub_title">Sub Title</label>
                    <input type="text" name="sub_title" id="sub_title" placeholder="Subtitle" />
                </div>
            </div>

            <div class="two-col-form">
                <div>
                    <label for="btn_text">Button Text (Max Two Words)</label>
                    <input type="text" name="btn_text" id="btn_text" placeholder="e.g., Learn More" />
                </div>
                <div>
                    <label for="btn_link">Button Link</label>
                    <input type="url" name="btn_link" id="btn_link" placeholder="https://example.com" />
                </div>
            </div>

            <div class="two-col-form">
                <div>
                    <label for="banner_bg_image">Background Image</label>
                    <input type="file" name="banner_bg_image" id="banner_bg_image" />
                </div>
            </div>

            <input type="submit" class="form-submit-button" value="Add Banner">
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script>
$(document).ready(function() {
    const API_BASE_URL = "<?php echo e($API_BASE_URL); ?>";
    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
    const adminToken = '<?php echo e(session('admin_api_token')); ?>';

    $('#bannerForm').on('submit', function(e) {
        e.preventDefault();
        let formData = new FormData(this);

        $.ajax({
            url: `${API_BASE_URL}/banners`,
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            headers: {
                'X-CSRF-TOKEN': csrfToken,
                'Accept': 'application/json',
                ...(adminToken && { 'Authorization': `Bearer ${adminToken}` })
            },
            success: function(response) {
                alert('Banner added successfully');
                location.reload();
            },
            error: function(xhr) {
                let errorMessage = xhr.responseJSON?.message || 'Something went wrong.';
                alert('Error: ' + errorMessage);
            }
        });
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layout.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/microsols/public_html/api.microsols.com/resources/views/admin/addBanner.blade.php ENDPATH**/ ?>