document.getElementById('logoutBtn').addEventListener('click', async function () {
    console.log("Button Click");
    
    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
    const adminToken = localStorage.getItem('admin_token');

    if (!adminToken) {
        alert('You are already logged out.');
        window.location.href = "/login";
        return;
    }

    try {
        const response = await fetch(`/logout`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'Accept': 'application/json',
                'Authorization': `Bearer ${adminToken}`,
                'X-CSRF-TOKEN': csrfToken
            },
        });

        const data = await response.json();

        if (response.ok) {
            window.location.href = "/login"; // Redirect to login page
        } else {
            alert(data.message || 'Logout failed.');
        }

    } catch (error) {
        console.error('Logout error:', error);
        alert('Something went wrong during logout.');
    }
})