@extends('admin.layout.base')

@section('content')
<div class="content-container">
    <div class="form-container">
        <h2 class="page-heading">Add Popup</h2>
        <form id="popupForm" enctype="multipart/form-data">
            <div class="two-col-form">
                <div>
                    <label for="duration">Duration (Days)</label>
                    <input type="number" name="duration" id="duration" placeholder="Duration in days" />
                </div>
                <div>
                    <label for="expire_date">Expire Date</label>
                    <input type="date" name="expire_date" id="expire_date" placeholder="Expire Date" />
                </div>
            </div>

            <div class="two-col-form">
                <div>
                    <label for="popup_image">Popup Image</label>
                    <input type="file" name="popup_image" id="popup_image" />
                </div>
            </div>

            <input type="submit" class="form-submit-button" value="Add Popup">
        </form>
    </div>
</div>
@endsection

@push('js')
<script>
$(document).ready(function() {
    const API_BASE_URL = "{{ $API_BASE_URL }}";
    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
    const adminToken = '{{ session('admin_api_token') }}';

    $('#popupForm').on('submit', function(e) {
        e.preventDefault();
        let formData = new FormData(this);

        $.ajax({
            url: `${API_BASE_URL}/popups`,
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            headers: {
                'X-CSRF-TOKEN': csrfToken,
                'Accept': 'application/json',
                ...(adminToken && { 'Authorization': `Bearer ${adminToken}` })
            },
            success: function(response) {
                alert('Popup added successfully');
                location.reload();
            },
            error: function(xhr) {
                let errorMessage = xhr.responseJSON?.message || 'Something went wrong.';
                alert('Error: ' + errorMessage);
            }
        });
    });
});
</script>
@endpush
