@extends('admin.layout.base')

@push('styles')
<link rel="stylesheet" href="https://cdn.datatables.net/2.2.2/css/dataTables.dataTables.min.css">
@endpush

@section('content')
<div class="content-container">
    <div class="table-container">
        <table id="bannersTable" class="display">
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Sub Title</th>
                    <th>Btn Text</th>
                    <th>Btn Link</th>
                    <th>Duration</th>
                    <th>Expire Date</th>
                    <th>Banner Image</th>
                    <th>Actions</th> <!-- 🔹 New column for Delete -->
                </tr>
            </thead>
            <tbody>
                <!-- Data will be inserted here via AJAX -->
            </tbody>
        </table>
    </div>
</div>
@endsection

@push('js')
<script src="https://cdn.datatables.net/2.2.2/js/dataTables.min.js"></script>

<script>
$(document).ready(function() {
    const API_BASE_URL = "{{ $API_BASE_URL }}";
    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
    const adminToken = '{{ session('admin_api_token') }}';

    const table = $('#bannersTable').DataTable({
        processing: true,
        serverSide: false,
        ajax: {
            url: `${API_BASE_URL}/banners`,
            type: "GET",
            dataSrc: "",
            beforeSend: function(xhr) {
                xhr.setRequestHeader('Accept', 'application/json');
                xhr.setRequestHeader('X-CSRF-TOKEN', csrfToken);
                if (adminToken) {
                    xhr.setRequestHeader('Authorization', `Bearer ${adminToken}`);
                }
            }
        },
        columns: [
            { data: "title" },
            { data: "sub_title" },
            { data: "btn_text" },
            {
                data: "btn_link",
                render: function(data) {
                    return `<a href="${data}" target="_blank">${data}</a>`;
                }
            },
            { data: "banner_duration" },
            { data: "expire_date" },
            {
                data: "banner_bg_image",
                render: function(data) {
                    return `<img src="/${data}" width="100" alt="Banner Image">`;
                }
            },
            {
                data: "id",
                render: function(id) {
                    return `<button class="delete-btn" data-id="${id}" style="color: red;">Delete</button>`;
                }
            }
        ]
    });

    // 🔹 Handle delete click
    $('#bannersTable').on('click', '.delete-btn', function() {
        const bannerId = $(this).data('id');

        if (confirm('Are you sure you want to delete this banner?')) {
            $.ajax({
                url: `${API_BASE_URL}/banners/${bannerId}`,
                type: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': csrfToken,
                    'Accept': 'application/json',
                    ...(adminToken && { 'Authorization': `Bearer ${adminToken}` })
                },
                success: function(response) {
                    alert('Banner deleted successfully.');
                    table.ajax.reload();
                },
                error: function(xhr) {
                    let errorMessage = xhr.responseJSON?.message || 'Failed to delete banner.';
                    alert('Error: ' + errorMessage);
                }
            });
        }
    });
});
</script>
@endpush
