<?php

namespace App\Services;

use Google\Client;
use Illuminate\Support\Facades\Http;

class FirebaseService
{
    protected $client;
    protected $projectId;

    public function __construct()
    {
        $this->client = new Client();
        $credentialsPath = storage_path('app/firebase/numberlee_firebase.json');
        $this->client->setAuthConfig($credentialsPath);
        $this->client->addScope('https://www.googleapis.com/auth/firebase.messaging');
        $this->client->fetchAccessTokenWithAssertion();

        $serviceAccount = json_decode(file_get_contents($credentialsPath), true);
        $this->projectId = $serviceAccount['project_id'];
    }

    public function sendPushNotification($token, $title, $body)
    {
        $url = "https://fcm.googleapis.com/v1/projects/{$this->projectId}/messages:send";

        $accessToken = $this->client->getAccessToken()['access_token'];

        $message = [
            "message" => [
                "token" => $token,
                "notification" => [
                    "title" => $title,
                    "body" => $body,
                ],
                "android" => [
                    "priority" => "high",
                ],
                "apns" => [
                    "headers" => [
                        "apns-priority" => "10",
                    ],
                ],
            ],
        ];

        $response = Http::withToken($accessToken)
            ->post($url, $message);

        if ($response->failed()) {
            \Log::error('FCM Failed', [
                'response' => $response->json()
            ]);
        } else {
            \Log::info('FCM Sent', [
                'response' => $response->json()
            ]);
        }

        return $response->json();
    }

}
