@extends('admin.layout.base')

@push('styles')
<link rel="stylesheet" href="https://cdn.datatables.net/2.2.2/css/dataTables.dataTables.min.css">
@endpush

@section('content')
<div class="content-container">
    <div class="table-container">
        <table id="NotificationTable" class="display">
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Message</th>
                    <th>Delivery Date</th>
                    <th>Actions</th> 
                </tr>
            </thead>
            <tbody>
                <!-- Data will be inserted here via AJAX -->
            </tbody>
        </table>
    </div>
</div>
@endsection

@push('js')
<script src="https://cdn.datatables.net/2.2.2/js/dataTables.min.js"></script>

<script>
$(document).ready(function() {
    const API_BASE_URL = "{{ $API_BASE_URL }}";
    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
    const adminToken = '{{ session('admin_api_token') }}'; // get stored token

    const table = $('#NotificationTable').DataTable({
        processing: true,
        serverSide: false,
        ajax: {
            url: `${API_BASE_URL}/notifications/get`,
            type: "GET",
            dataSrc: "",
            beforeSend: function(xhr) {
                xhr.setRequestHeader('Accept', 'application/json');
                xhr.setRequestHeader('X-CSRF-TOKEN', csrfToken);
                if (adminToken) {
                    xhr.setRequestHeader('Authorization', `Bearer ${adminToken}`);
                }
            }
        },
        columns: [
            { data: "title" },
            { data: "message" },
            { 
                data: "created_at",
                render: function(data, type, row) {
                    let date = new Date(data);
                    let formattedDate = date.toLocaleDateString('en-GB', {
                        day: 'numeric',
                        month: 'long',
                        year: 'numeric'
                    });
                    return formattedDate;
                },
                className: "text-center"
            },
            {
                data: "id",
                render: function(id) {
                    return `<button class="delete-btn" data-id="${id}" style="color: red;">Delete</button>`;
                }
            }
        ]
    });

    // 🔹 Handle delete click
    $('#NotificationTable').on('click', '.delete-btn', function() {
        const notificationId = $(this).data('id');

        if (confirm('Are you sure you want to delete this banner?')) {
            $.ajax({
                url: `${API_BASE_URL}/notifications/${notificationId}`,
                type: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': csrfToken,
                    'Accept': 'application/json',
                    ...(adminToken && { 'Authorization': `Bearer ${adminToken}` })
                },
                success: function(response) {
                    alert('Notification deleted successfully.');
                    table.ajax.reload();
                },
                error: function(xhr) {
                    let errorMessage = xhr.responseJSON?.message || 'Failed to delete banner.';
                    alert('Error: ' + errorMessage);
                }
            });
        }
    });

});
</script>
@endpush
