<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Dashboard</title>
    <?php echo $__env->yieldPushContent('styles'); ?>
   <link rel="stylesheet" href="<?php echo e(url('/assets/css/style.css')); ?>?v=<?php echo e(filemtime(public_path('assets/css/style.css'))); ?>" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

  </head>
  <body>
    <header class="header">
      <div class="logo-wrapper">
        <h2 class="logo-text">Numberlee</h2>
      </div>
      <div class="header-content-wrapper">
       
        <div class="header-content">
          <div class="user-content-container">
            <div class="user-details">
              <h2>Welcome Back ! <?php echo e(ucwords(auth()->user()->fullname)); ?></h2>
              <h4><?php echo e(auth()->user()->email); ?></h4>
            </div>
          </div>
          <div class="search-icons-container">
            <div class="icon-container" id="logoutBtn">
              <img src="<?php echo e(url("assets/images/icons/logout.png")); ?>" alt="logout" />
            </div>
          </div>
        </div>
      </div>
    </header>
    <div class="content-wrapper">
    <aside class="side-navigation">
  <div>
    
    <a href="<?php echo e(route('admin.dashboard')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.dashboard') ? 'link-active' : ''); ?>">
      <img src="<?php echo e(url('assets/images/icons/dashboard-icon.png')); ?>" alt="dashboard-icon" />
      <span>Dashboard</span>
    </a>

    
    <div class="dropdown-link-wrapper">
      <a href="#" class="nav-link nav-link-dropdown <?php echo e(request()->routeIs('banners', 'banners.add') ? 'link-active' : ''); ?>">
        <img src="<?php echo e(url('assets/images/icons/users-icon.png')); ?>" alt="users-icon" />
        <span>Banners</span>
        <img src="<?php echo e(url('assets/images/icons/icon-dropdown.png')); ?>" alt="dropdown-arrow" class="dropdown-icon" />
      </a>
      <div class="dropdown-link-body">
        <a href="<?php echo e(route('banners')); ?>" class="<?php echo e(request()->routeIs('banners') ? 'link-active' : ''); ?>">All Banners</a>
        <a href="<?php echo e(route('banners.add')); ?>" class="<?php echo e(request()->routeIs('banners.add') ? 'link-active' : ''); ?>">Add Banner</a>
      </div>
    </div>

    
    <div class="dropdown-link-wrapper">
      <a href="#" class="nav-link nav-link-dropdown <?php echo e(request()->routeIs('notifications', 'notifications.add') ? 'link-active' : ''); ?>">
        <img src="<?php echo e(url('assets/images/icons/users-icon.png')); ?>" alt="users-icon" />
        <span>Notifications</span>
        <img src="<?php echo e(url('assets/images/icons/icon-dropdown.png')); ?>" alt="dropdown-arrow" class="dropdown-icon" />
      </a>
      <div class="dropdown-link-body">
        <a href="<?php echo e(route('notifications')); ?>" class="<?php echo e(request()->routeIs('notifications') ? 'link-active' : ''); ?>">All Notifications</a>
        <a href="<?php echo e(route('notifications.add')); ?>" class="<?php echo e(request()->routeIs('notifications.add') ? 'link-active' : ''); ?>">Send Notification</a>
      </div>
    </div>

    
    <div class="dropdown-link-wrapper">
      <a href="#" class="nav-link nav-link-dropdown <?php echo e(request()->routeIs('popup', 'popup.add') ? 'link-active' : ''); ?>">
        <img src="<?php echo e(url('assets/images/icons/users-icon.png')); ?>" alt="users-icon" />
        <span>Popups</span>
        <img src="<?php echo e(url('assets/images/icons/icon-dropdown.png')); ?>" alt="dropdown-arrow" class="dropdown-icon" />
      </a>
      <div class="dropdown-link-body">
        <a href="<?php echo e(route('popup')); ?>" class="<?php echo e(request()->routeIs('popup') ? 'link-active' : ''); ?>">All Popups</a>
        <a href="<?php echo e(route('popup.add')); ?>" class="<?php echo e(request()->routeIs('popup.add') ? 'link-active' : ''); ?>">Send Popup</a>
      </div>
    </div>

    
    <div class="dropdown-link-wrapper">
      <a href="#" class="nav-link nav-link-dropdown <?php echo e(request()->routeIs('users', 'users.add') ? 'link-active' : ''); ?>">
        <img src="<?php echo e(url('assets/images/icons/users-icon.png')); ?>" alt="users-icon" />
        <span>Users</span>
        <img src="<?php echo e(url('assets/images/icons/icon-dropdown.png')); ?>" alt="dropdown-arrow" class="dropdown-icon" />
      </a>
      <div class="dropdown-link-body">
        <a href="<?php echo e(route('users')); ?>" class="<?php echo e(request()->routeIs('users') ? 'link-active' : ''); ?>">All Users</a>
        
      </div>
    </div>

    
    <a href="<?php echo e(route('admin.profile')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.profile') ? 'link-active' : ''); ?>">
      <img src="<?php echo e(url('assets/images/icons/gear-icon.png')); ?>" alt="gear-icon" />
      <span>Profile Setting</span>
    </a>

  </div>
</aside>
<?php /**PATH /home/microsols/public_html/api.microsols.com/resources/views/admin/layout/header.blade.php ENDPATH**/ ?>