
<?php $__env->startSection('content'); ?>
<div class="content-container">
    <div class="form-container">
        <h2 class="page-heading">Send Notification</h2>
        <form id="notificationForm">
            <div class="two-col-form">
                <div>
                    <label for="title">Title</label>
                    <input
                        type="text"
                        name="title"
                        id="title"
                        placeholder="Enter notification title"
                        required
                    />
                </div>
                <div>
                    <label for="message">Message</label>
                    <input
                        type="text"
                        name="message"
                        id="message"
                        placeholder="Enter notification message"
                        required
                    />
                </div>
            </div>

            <input type="submit" class="form-submit-button" value="Send Notification">
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script>
$(document).ready(function() {
    const API_BASE_URL = "<?php echo e($API_BASE_URL); ?>";
    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
    const adminToken = '<?php echo e(session('admin_api_token')); ?>';

    $('#notificationForm').on('submit', function(e) {
        e.preventDefault();

        let formData = {
            title: $('#title').val(),
            message: $('#message').val(),
        };

        const userId = $('#user_id').val();
        if (userId) {
            formData.user_id = userId;
        }

        $.ajax({
            url: `${API_BASE_URL}/notifications/send`, // your createNotification API
            type: "POST",
            data: formData,
            headers: {
                'X-CSRF-TOKEN': csrfToken,
                'Accept': 'application/json',
                ...(adminToken && { 'Authorization': `Bearer ${adminToken}` })
            },
            success: function(response) {
                alert('Notification sent and saved successfully.');
                location.reload();
            },
            error: function(xhr) {
                let errorMessage = xhr.responseJSON?.message || 'Something went wrong.';
                alert('Error: ' + errorMessage);
            }
        });
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layout.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/microsols/public_html/api.microsols.com/resources/views/admin/addFcmNotification.blade.php ENDPATH**/ ?>