<?php

namespace App\DataTables\Settings;


use Yajra\DataTables\DataTableAbstract;
use Yajra\DataTables\Html\Builder as HtmlBuilder;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Services\DataTable;
use Illuminate\Support\Facades\Http;

class JobTypeDataTable extends DataTable
{
     /**
     * Build the DataTable class.
     *
     * @param DataTableAbstract $query
     */
    public function dataTable($query): DataTableAbstract
    {
        return datatables()->of($query);
    }

    /**
     * Get the query source of dataTable.
     *
     * @return \Illuminate\Support\Collection
     */
    public function query()
    {
        // Fetch data from the external API
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->get("$apiBaseUrl/job_types");
       
        // Check if the response is successful
        if ($response->successful()) {
            // Return the JSON data from 'courses' key
            return collect($response->json()['job_types']);
        }

        // Return an empty collection if the API call fails
        return collect([]);
    }

    /**
     * Optional method if you want to use the HTML builder.
     */
    public function html(): HtmlBuilder
    {
        return $this->builder()
                    ->setTableId('job_type_table')
                    ->columns($this->getColumns())
                    ->minifiedAjax()
                    ->orderBy(1)
                    ->selectStyleSingle();
    }

    /**
     * Get the DataTable columns definition.
     */
    public function getColumns(): array
    {
        return [
            Column::make('id'),
            Column::make('job_type'),
            Column::make('created_at'),
            Column::make('updated_at'),
        ];
    }

    /**
     * Get the filename for export.
     */
    protected function filename(): string
    {
        return 'JobType_' . date('YmdHis');
    }
}
