<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;

class AuthController extends Controller
{
    public function login_view()
    {
        // Redirect to the home page if already logged in
        if (session()->has('bearer_token')) {
            return redirect()->route('home');
        }

        return view('auth.login');
    }
    public function login(Request $request)
    {
        // Validate the request
        $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);

        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::post("$apiBaseUrl/login", [
            'email' => $request->email,
            'password' => $request->password,
        ]);

        if ($response->successful()) {
            $data = $response->json();
            $token = 'Bearer ' . $data['access_token'];
            $role = $data['role'];
            $permissions = $data['permissions'];
            $org_id = $data['org_id'];
            $id = $data['id'];
            $logo = $data['logo'];
            $currency = $data['currency'];
            $employee_id = $data['employee_id'];
            $user_name = $data['user_name'];
            $designation = $data['designation'];

            // Store token, role, and permissions in the session
            session([
                'bearer_token' => $token,
                'role' => $role,
                'permissions' => $permissions,
                'org_id' => $org_id,
                'id' => $id,
                'logo' => $logo,
                'currency' => $currency,
                'employee_id' => $employee_id,
                'user_name' => $user_name,
                'designation' => $designation,
            ]);

            // Redirect to the dashboard with a success message
            return redirect('/')->with('success', 'Logged in successfully');
        }

        // Pass the API response message to the login view as error
        $message = $response->json('message', 'Credentials did not match');
        return redirect()->route('login_view')->with('error', $message);
    }

    public function logout(Request $request)
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
      
        $response = Http::withToken($token)->post("$apiBaseUrl/logout");

        if ($response->successful()) {
            session()->forget(['bearer_token', 'role', 'permissions','org_id','id','logo','employee_id','user_name','designation']);
            return redirect()->route('login_view')->with('success', 'Logged out successfully');
        } else {


            return redirect()->route('login_view')->with('error', 'Unable to logout');
        }
    }


    public function home()
    {
        try {
            // Retrieve the token from the session
            $token = session('bearer_token');
            $org_id = session('org_id');
            $role = session('role'); // Assuming you store the role in the session

            // Retrieve the base API URL from environment variables
            $apiBaseUrl = env('API_BASE_URL');

            // Make the API request with the token
            $response = Http::withToken($token)->get("{$apiBaseUrl}/dashboard?org_id=$org_id");

            // Check if the response is successful
            if ($response->successful()) {
                // Decode the JSON response
                $data = $response->json();

                // Pass the data and role to the view
                return view('admin.dashboard', compact('data', 'role'));
            } else {
                // Return a 404 response if the data is not found
                return response()->json(['status' => 404, 'message' => 'Dashboard data not found.'], 404);
            }
        } catch (\Exception $e) {
            // Handle exceptions and return an error response
            return response()->json(['message' => 'An error occurred: ' . $e->getMessage()], 500);
        }
    }

    public function checkSession(Request $request)
    {
        $sessionData = [
            'permissions' => session('permissions'),
            'logo' => session('logo'),
            'role' => session('role'),
            'org_id' => session('org_id'),
            'bearer_token' => session('bearer_token'),
        ];
    
        return response()->json($sessionData);
    }

    public function restoreSessionData(Request $request)
    {   
        session([
            'bearer_token' => $request->bearer_token,
            'role' => $request->role,
            'permissions' => $request->permissions,
            'org_id' => $request->org_id,
            'id' => $request->id,
            'logo' => $request->logo,
            'currency' =>  $request->currency,
            'employee_id' => $request->employee_id,
            'user_name' => $request->user_name,
            'designation' => $request->designation,
        ]);
    
        return response()->json(['success' => true]);
    }
    

}
