<?php

namespace App\Http\Controllers\Settings;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;


class DepartmentController extends Controller
{
    public function department_list()
    {
        return view('admin.settings.department');
    }
    public function add_department_form(Request $request)
    {

        $request->validate([
            'department' => 'required|string|max:255',
        ]);

        try {
            $token = session('bearer_token');
            $org_id = session('org_id');


            $apiBaseUrl = env('API_BASE_URL');
            $response = Http::withToken($token)->post("{$apiBaseUrl}/departments/store", [
                'department' => $request->department,
                'org_id' => $org_id
            ]);

            if ($response->successful()) {
                return response()->json([
                    'success' => true,
                    'message' => 'Department added successfully'
                ]);
            } else {
                $error = $response->json();
                return response()->json([
                    'success' => false,
                    'errors' => $error['errors'] ?? 'Failed to add Department.'
                ], $response->status());
            }
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Something went wrong: ' . $e->getMessage()
            ], 500);
        }
    }

    public function update_department_form(Request $request, $id)
    {
        try {

            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');

            $response = Http::withToken($token)->put("{$apiBaseUrl}/departments/update/{$id}", [
                'department' => $request->department,
            ]);

            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => 'Department updated successfully']);
            } else {

                $error = $response->json();
                return response()->json([
                    'success' => false,
                    'errors' => $error['errors'] ?? 'Failed to update department.'
                ], $response->status());
            }
        } catch (\Exception $e) {

            return response()->json(['success' => false, 'message' => 'Something went wrong: ' . $e->getMessage()], 500);
        }
    }


    public function delete_department($id)
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->delete("{$apiBaseUrl}/departments/{$id}");

        if ($response->successful()) {
            return response()->json(['success' => true, 'message' => 'Department deleted successfully']);
        } else {
            $error = $response->json();
            return response()->json([
                'success' => false,
                'message' => $error['message'] ?? 'Unable to delete Department'
            ], $response->status());
        }
    }

    public function get_department($id)
    {
        try {
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
            $response = Http::withToken($token)->get("{$apiBaseUrl}/departments/get/{$id}");



            if ($response->successful()) {
                return response()->json($response->json()['department']);
            } else {
                return response()->json(['status' => 404, 'message' => 'Department not found.'], 404);
            }
        } catch (\Exception $e) {
            dd('An error occurred: ' . $e->getMessage());
            return response()->json(['message' => 'An error occurred: ' . $e->getMessage()], 500);
        }
    }
}
