@extends('admin.layout.main')

@section('content')
    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    Shift List
                </h3>
                <nav class="col-md-6 text-right" aria-label="breadcrumb">
                    <button data-bs-toggle="modal" id="add_shift" class="btn btn-sm btn-outline-primary">
                        <i class="fa fa-plus-circle mr-sm-2"></i>Create Shift</button>
                </nav>
                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a
                                style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Shift List
                        </li>
                    </ol>
                </nav>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table id="shift_table" class="data_table table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>id</th>
                                            <th>Shift</th>
                                            <th>Created at</th>
                                            <th>Updated at</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>




    <div class="modal fade" id="createShift" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Add Shift</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="addShiftForm" method="POST">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        @csrf
                        <label for="">Shift</label>
                        <input type="text" class="form-control" id="shift" name="shift" placeholder="Enter Shift"
                            required></input>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Add</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="updateShift" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Update shift</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="updateShiftForm">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        @csrf
                        <input type="hidden" name="shift_id" id="shift_id">
                        <label for="">Shift</label>
                        <input class="form-control" type="text" id="update_shift" name="shift"
                            placeholder="Enter Shift" required></input>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Update</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    @push('js')
        <script>
            $(document).ready(function() {
                var session_data = @json(session()->all());
                
                $('#shift_table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: '{{ env('API_BASE_URL') }}/shift/index',
                        beforeSend: function(xhr) {
                            xhr.setRequestHeader('Authorization', session_data.bearer_token);
                        },
                        complete: function(response) {
                            // After the API call is complete, restore the session data
                            if (response.status === 200) {
                                $.ajax({
                                    type: 'GET',
                                    url: '{{ route('restore_session_data') }}',
                                    data: {
                                        bearer_token: session_data.bearer_token,
                                        role: session_data.role,
                                        permissions: session_data.permissions,
                                        org_id: session_data.org_id,
                                        id: session_data.id,
                                        currency: session_data.currency,
                                        logo: session_data.logo,
                                        employee_id: session_data.employee_id,
                                        user_name: session_data.user_name,
                                        designation: session_data.designation,
                                    },
                                    success: function(data) {
                                        if (data.success) {
                                            console.log("Session restored successfully");
                                        } else {
                                            console.error("Failed to restore session");
                                        }
                                        console.log(data);
                                    },
                                    error: function(xhr) {
                                        console.error("Error restoring session:", xhr);
                                    }
                                });

                            }
                        }
                    },
                    columns: [{
                            data: 'count',
                            name: 'count'
                        },
                        {
                            data: 'id',
                            name: 'id',
                            visible: false
                        },
                        {
                            data: 'shift',
                            name: 'shift'
                        },
                        {
                            data: 'created_at',
                            name: 'created_at',
                            render: function(data) {
                                return new Date(data).toLocaleDateString('en-GB', {
                                    day: '2-digit',
                                    month: 'short',
                                    year: 'numeric'
                                });
                            }
                        },
                        {
                            data: 'updated_at',
                            name: 'updated_at',
                            render: function(data) {
                                return new Date(data).toLocaleDateString('en-GB', {
                                    day: '2-digit',
                                    month: 'short',
                                    year: 'numeric'
                                });
                            }
                        },
                        {
                            data: null,
                            name: 'action',
                            render: function(data, type, row) {
                                return `
                    <div class="dropdown">
                        <a style="font-size: 19px; color:black; text-decoration: none;" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            ⋮
                        </a>
                        <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                            <button data-id="${row.id}" id="editshifttbtn" class="dropdown-item text-primary">
                                <i class="fa fa-pen mr-2"></i> Edit
                            </button>
                            <button data-id="${row.id}" id="delete_shift" class="dropdown-item text-danger">
                                <i class="far fa-trash-alt mr-2"></i> Delete
                            </button>
                        </div>
                    </div>
                `;
                            }
                        }
                    ]
                });




                $('#add_shift').on('click', function() {
                    $('#createShift').modal('show');
                });
                $('#addShiftForm').on('submit', function(e) {
                    e.preventDefault();

                    let $submitButton = $('#addShiftForm button[type="submit"]');
                    $submitButton.prop('disabled', true);

                    $.ajax({
                        type: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('add_shift_form') }}",
                        data: $(this).serialize(),
                        success: function(response) {
                            if (response.success) {
                                $('#createShift').modal('hide');
                                $('#shift_table').DataTable().ajax.reload();
                                $('#addShiftForm')[0].reset();
                                toastr.success(response.message);
                            } else {
                                // Handle non-validation errors
                                let errorMessage = response.message || 'An error occurred.';
                                toastr.error(errorMessage);
                            }
                        },
                        error: function(xhr) {
                            let response = xhr.responseJSON;

                            if (xhr.status === 422 && response.errors) {
                                // Get the first error message from the 'shift' field
                                let firstError = response.errors.shift ? response.errors.shift[0] :
                                    'An error occurred.';
                                toastr.error(firstError); // Show the error message
                            } else if (response && response.message) {
                                toastr.error(response.message);
                            } else {
                                toastr.error('An error occurred while adding the shift.');
                            }
                        },
                        complete: function() {
                            $submitButton.prop('disabled', false);
                        }
                    });
                });

                $('body').on('click', '#delete_shift', function() {
                    var id = $(this).data('id');

                    $.ajax({
                        type: "DELETE",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('delete_shift', ['id' => ':id']) }}"
                            .replace(':id', id),
                        success: function(response) {
                            $('#shift_table').DataTable().ajax.reload();
                            // Show success Toastr message
                            toastr.success('Shift deleted successfully');
                        },
                        error: function(xhr) {
                            // Display error Toastr message
                            let errorMessage = 'An error occurred while deleting the Shift.';
                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorMessage = xhr.responseJSON.message;
                            }
                            toastr.error(errorMessage);
                        }
                    });
                });

                $('body').on('click', '#editshifttbtn', function() {
                    var id = $(this).data('id');



                    $.ajax({
                        type: "GET",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('get_shift', ['id' => ':id']) }}"
                            .replace(':id', id),
                        success: function(response) {

                            if (response.status === 404) {
                                $('#updateShift').modal('hide');
                                toastr.error('Education not found.');
                            } else {
                                $('#updateShift').modal('show');
                                var shift =
                                    response; // response is already the department data
                                $('#shift_id').val(shift.id);
                                $('#update_shift').val(shift.shift);
                            }
                        },
                        error: function(xhr) {

                            toastr.error('An error occurred while fetching the Shift.');
                        }
                    });
                });

                $('#updateShiftForm').on('submit', function(e) {
                    e.preventDefault();

                    var id = $('#shift_id').val(); // Use the correct ID

                    // Disable the submit button to prevent multiple submissions
                    let $submitButton = $('#updateShiftForm button[type="submit"]');
                    $submitButton.prop('disabled', true);

                    $.ajax({
                        type: 'PUT',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('update_shift_form', ['id' => ':id']) }}".replace(':id',
                            id),
                        data: $(this).serialize(),
                        success: function(response) {
                            console.log("AJAX Success:", response); // Log response for debugging

                            if (response.success) {
                                $('#updateShift').modal('hide');
                                $('#shift_table').DataTable().ajax
                                    .reload(); // Reload DataTable
                                toastr.success(response.message);
                                $('#updateShiftForm')[0].reset();
                            } else {
                                // Handle non-validation errors
                                let errorMessage = response.message || 'An error occurred.';
                                toastr.error(errorMessage);
                            }
                        },
                        error: function(xhr) {
                            let response = xhr.responseJSON;

                            if (xhr.status === 422 && response.errors) {
                                // Get the first error message from the 'shift' field
                                let firstError = response.errors.shift ? response.errors.shift[0] :
                                    'An error occurred.';
                                toastr.error(firstError); // Show the error message
                            } else if (response && response.message) {
                                toastr.error(response.message);
                            } else {
                                toastr.error('An error occurred while adding the shift.');
                            }
                        },
                        complete: function() {
                            $submitButton.prop('disabled', false);
                        }
                    });
                });

            });
        </script>
    @endpush
@endsection
