

<?php $__env->startSection('content'); ?>
    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    Expense List
                </h3>
                <nav class="col-md-6 text-right" aria-label="breadcrumb">
                    <button data-bs-toggle="modal" id="add_expense" class="btn btn-sm btn-outline-primary">
                        <i class="fa fa-plus-circle mr-sm-2"></i>Create Expense </button>
                </nav>
                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a
                                style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Expense List
                        </li>
                    </ol>
                </nav>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table id="expense_table" class="data_table table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Amount</th>
                                            <th>Date</th>
                                            <th>Description</th>
                                            <th>Status</th>

                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>




    <div class="modal fade" id="createExpense" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Add Expense</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="addExpenseForm" method="POST">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        <?php echo csrf_field(); ?>

                        <label>Amount</label>
                        <input class="form-control" type="number" id="amount" name="amount" placeholder="Enter amount"
                            required></input>

                        <label class="mt-4">Date</label>
                        <input class="form-control" type="date" id="date" name="date" placeholder="Enter date"
                            required></input>

                        <label class="mt-4">Status</label>
                        <select type="text" class="form-control" id="status" name="status"
                            placeholder="Enter Education" required>
                            <option selected disabled>Select Status</option>
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>


                        <label class="mt-4">Description</label>
                        <textarea class="form-control" type="text" id="description" name="description" rows="5"
                            placeholder="Enter description" required></textarea>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Add</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="updateExpense" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Update Expense</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="updateExpenseForm">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="expense_id" id="expense_id">



                        <label>Amount</label>
                        <input class="form-control" type="number" id="update_amount" name="amount"
                            placeholder="Enter amount" required></input>

                        <label class="mt-4">Date</label>
                        <input class="form-control" type="date" id="update_date" name="date"
                            placeholder="Enter date" required></input>



                        <label class="mt-4">Status</label>
                        <select type="text" class="form-control" id="update_status" name="status"
                            placeholder="Enter Education" required>
                            <option selected disabled>Select Status</option>
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>


                        <label class="mt-4">Description</label>
                        <textarea class="form-control" type="text" id="update_description" name="description" rows="5"
                            placeholder="Enter description" required></textarea>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Update</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php $__env->startPush('js'); ?>
        <script>
            $(document).ready(function() {
                $('#expense_table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: '<?php echo e(route('expense_list')); ?>',
                    columns: [{
                            data: 'id',
                            name: 'id'
                        },
                        {
                            data: 'amount',
                            name: 'amount'
                        },

                        {
                            data: 'date',
                            name: 'date',
                            render: function(data) {
                                return new Date(data).toLocaleDateString('en-GB', {
                                    day: '2-digit',
                                    month: 'short',
                                    year: 'numeric'
                                });
                            }
                        },
                        {
                            data: 'description',
                            name: 'description'
                        },

                        {
                            data: 'status',
                            name: 'status'
                        },



                        {
                            data: null,
                            name: 'action',
                            render: function(data, type, row) {
                                return `
                        <div class="dropdown">
                            <a style="font-size: 19px; color:black; text-decoration: none;" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                ⋮
                            </a>

                            <div class="dropdown-menu"  aria-labelledby="dropdownMenuLink" x-placement="bottom-start" style="position: absolute; transform: translate3d(0px, 21px, 0px); top: 0px; left: 0px; will-change: transform;">
                                <button data-id="${row.id}" id="editexpensebtn"  class="dropdown-item text-primary">
                                    <i class="fa fa-pen mr-2"></i> Edit
                                </button>
                                <button data-id="${row.id}" id="delete_expense"  class="dropdown-item text-danger">
                                    <i class="far fa-trash-alt mr-2"></i> Delete
                                </button>
                            </div>
                        </div>
                    `;
                            }
                        }
                    ]
                });


                $('#add_expense').on('click', function() {
                    $('#createExpense').modal('show');
                });
                $('#addExpenseForm').on('submit', function(e) {
                    e.preventDefault();

                    let $submitButton = $('#addExpenseForm button[type="submit"]');
                    $submitButton.prop('disabled', true);

                    $.ajax({
                        type: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('add_expense_form')); ?>",
                        data: $(this).serialize(),
                        success: function(response) {
                            if (response.success) {
                                $('#createExpense').modal('hide');
                                $('#expense_table').DataTable().ajax.reload();
                                $('#addExpenseForm')[0].reset();
                                toastr.success(response.message);
                            } else {
                                let errorMessage = response.message;
                                if (response.errors) {
                                    errorMessage += '<br><br>Errors:<ul>';
                                    $.each(response.errors, function(key, errors) {
                                        $.each(errors, function(index, error) {
                                            errorMessage += '<li>' + error +
                                                '</li>';
                                        });
                                    });
                                    errorMessage += '</ul>';
                                }
                                toastr.error(errorMessage);
                            }
                        },
                        error: function(xhr) {
                            console.log("AJAX Error:", xhr);
                            toastr.error('Invalid Details '); // General error message
                        },
                        complete: function() {
                            $submitButton.prop('disabled', false);
                        }
                    });
                });
                $('body').on('click', '#delete_expense', function() {
                    var id = $(this).data('id');

                    $.ajax({
                        type: "DELETE",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('delete_expense', ['id' => ':id'])); ?>"
                            .replace(':id', id),
                        success: function(response) {
                            $('#expense_table').DataTable().ajax.reload();
                            // Show success Toastr message
                            toastr.success('Expense deleted successfully');
                        },
                        error: function(xhr) {
                            // Display error Toastr message
                            let errorMessage = 'An error occurred while deleting the Expense.';
                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorMessage = xhr.responseJSON.message;
                            }
                            toastr.error(errorMessage);
                        }
                    });
                });

                $('body').on('click', '#editexpensebtn', function() {
                    var id = $(this).data('id');



                    $.ajax({
                        type: "GET",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('get_expense', ['id' => ':id'])); ?>"
                            .replace(':id', id),
                        success: function(response) {

                            if (response.status === 404) {
                                $('#updateExpense').modal('hide');
                                toastr.error('Expense not found.');
                            } else {
                                $('#updateExpense').modal('show');
                                var expense =
                                    response;
                                console.log(expense); // response is already the department data
                                $('#expense_id').val(expense.id);
                                // $('#update_employee_id').val(expense.empoyee_id);
                                $('#update_amount').val(expense.amount);
                                $('#update_date').val(expense.date);
                                $('#update_status').val(expense.status);
                                $('#update_description').val(expense.description);
                            }
                        },
                        error: function(xhr) {

                            toastr.error('An error occurred while fetching the Expense.');
                        }
                    });
                });

                $('#updateExpenseForm').on('submit', function(e) {
                    e.preventDefault();

                    var id = $('#expense_id').val(); // Use the correct ID

                    // Disable the submit button to prevent multiple submissions
                    let $submitButton = $('#updateExpenseForm button[type="submit"]');
                    $submitButton.prop('disabled', true);

                    $.ajax({
                        type: 'PUT',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('update_expense_form', ['id' => ':id'])); ?>".replace(':id',
                            id),
                        data: $(this).serialize(),
                        success: function(response) {
                            console.log("AJAX Success:", response); // Log response for debugging

                            if (response.success) {
                                $('#updateExpense').modal('hide');
                                $('#expense_table').DataTable().ajax
                                    .reload(); // Reload DataTable
                                toastr.success(response.message);
                                $('#updateExpenseForm')[0].reset();
                            } else {
                                // Handle validation or other errors
                                let errorMessage = response.message || 'An error occurred.';
                                toastr.error(errorMessage); // Display error
                            }
                        },
                        error: function(xhr) {
                            console.log("AJAX Error:", xhr); // Log the error for debugging
                            let errorMessage = 'An unexpected error occurred.';
                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorMessage = xhr.responseJSON.message;
                            }
                            toastr.error(errorMessage); // Display error
                        },
                        complete: function() {
                            // Re-enable the submit button after the request completes
                            $submitButton.prop('disabled', false);
                        }
                    });
                });

            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\devioo_hrm\resources\views/admin/settings/expense.blade.php ENDPATH**/ ?>