

<?php $__env->startSection('content'); ?>
    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    Document List
                </h3>
                <nav class="col-md-6 text-right" aria-label="breadcrumb">
                    <button data-bs-toggle="modal" id="add_document" class="btn btn-sm btn-outline-primary">
                        <i class="fa fa-plus-circle mr-sm-2"></i>Create Document</button>
                </nav>
                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a
                                style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Document List
                        </li>
                    </ol>
                </nav>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table id="document_table" class="data_table table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Document</th>
                                            <th>Name</th>
                                            <th>Remind Date</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>




    <div class="modal fade" id="createDocument" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Add Document</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="addDocumentForm" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body" style="padding: 35px 15px !important">
                        <label for="document">Document</label>
                        <input type="file" class="form-control" id="document" name="document" required>
                        <label for="name" class="mt-4">Name</label>
                        <input type="text" class="form-control" id="name" name="name" required>
                        <label for="remind_date"  class="mt-4">Date</label>
                        <input type="date" class="form-control" id="remind_date" name="remind_date" required>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Add</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="updateDocument" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Update Document</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="updateDocumentForm" enctype="multipart/form-data" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="document_id" id="document_id">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        <label for="update_document">Document</label>
                        <input type="file" class="form-control" id="update_document" name="document">

                        <label for="update_name" class="mt-4">Name</label>
                        <input type="text" class="form-control" id="update_name" name="name" required>

                        <label for="update_remind_date"  class="mt-4">Date</label>
                        <input type="date" class="form-control" id="update_remind_date" name="remind_date">

                        <label for="status" class="mt-4" >Status</label>
                        <select name="status" id="status" class="form-control" required>
                            <option selected disabled>Select Status</option>
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>
                    </div>
                    <div class="modal-footer mt-4">
                        <button type="submit" class="btn btn-success">Update</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>



    <?php $__env->startPush('js'); ?>
        <script>
            $(document).ready(function() {
                $('#document_table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: '<?php echo e(route('document_list')); ?>',
                    columns: [{
                            data: 'id',
                            name: 'id'
                        },
                        {
                            data: 'document',
                            name: 'document'
                        },
                        {
                            data: 'name',
                            name: 'name'
                        },
                        

                        {
                            data: 'remind_date',
                            name: 'remind_date',
                            render: function(data) {
                                return new Date(data).toLocaleDateString('en-GB', {
                                    day: '2-digit',
                                    month: 'short',
                                    year: 'numeric'
                                });
                            }
                        },
                        {
                            data: 'status',
                            name: 'status'
                        },

                        {
                            data: null,
                            name: 'action',
                            render: function(data, type, row) {
                                return `
                        <div class="dropdown">
                            <a style="font-size: 19px; color:black; text-decoration: none;" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                ⋮
                            </a>

                            <div class="dropdown-menu"  aria-labelledby="dropdownMenuLink" x-placement="bottom-start" style="position: absolute; transform: translate3d(0px, 21px, 0px); top: 0px; left: 0px; will-change: transform;">
                                <button data-id="${row.id}" id="editdocumenttbtn"  class="dropdown-item text-primary">
                                    <i class="fa fa-pen mr-2"></i> Edit
                                </button>
                                <button data-id="${row.id}" id="delete_document"  class="dropdown-item text-danger">
                                    <i class="far fa-trash-alt mr-2"></i> Delete
                                </button>
                            </div>
                        </div>
                    `;
                            }
                        }
                    ]
                });


                $('#add_document').on('click', function() {
                    $('#createDocument').modal('show');
                });


                $('#addDocumentForm').on('submit', function(e) {
                    e.preventDefault(); // Prevent default form submission

                    let $submitButton = $('#addDocumentForm button[type="submit"]');
                    $submitButton.prop('disabled',
                        true); // Disable the submit button to avoid multiple submissions

                    // Create a new FormData object to handle file uploads
                    let formData = new FormData(this);

                    $.ajax({
                        url: '<?php echo e(route('add_document_form')); ?>', // Ensure this matches your route
                        type: 'POST',
                        data: formData,
                        contentType: false, // For multipart form data
                        processData: false, // Don't process the data (it's a file upload)
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr(
                                'content'), // Add CSRF token header
                        },
                        success: function(response) {
                            if (response.success) {
                                $('#createDocument').modal('hide'); // Hide the modal
                                $('#document_table').DataTable().ajax
                                    .reload(); // Reload DataTable if needed
                                $('#addDocumentForm')[0].reset(); // Reset the form
                                toastr.success(response.message); // Show success message
                            } else {
                                // Display errors in Toastify/Toastr
                                toastr.error(response.message); // Show error message
                            }
                        },
                        error: function(xhr) {
                            // Handle client-side or server-side errors
                            let errorMessage = 'Document could not be added. Please try again.';
                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorMessage = xhr.responseJSON
                                    .message; // Use API error message if available
                            }
                            toastr.error(errorMessage); // Show error message in Toastify/Toastr
                            console.log("AJAX Error:", xhr); // Log the error for debugging purposes
                        },
                        complete: function() {
                            $submitButton.prop('disabled',
                                false); // Re-enable the submit button after request completes
                        }
                    });
                });
                $('body').on('click', '#delete_document', function() {
                    var id = $(this).data('id');

                    $.ajax({
                        type: "DELETE",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('delete_document', ['id' => ':id'])); ?>"
                            .replace(':id', id),
                        success: function(response) {
                            $('#document_table').DataTable().ajax.reload();
                            // Show success Toastr message
                            toastr.success('Document deleted successfully');
                        },
                        error: function(xhr) {
                            // Display error Toastr message
                            let errorMessage = 'An error occurred while deleting the Document.';
                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorMessage = xhr.responseJSON.message;
                            }
                            toastr.error(errorMessage);
                        }
                    });
                });

                $('body').on('click', '#editdocumenttbtn', function() {
                    var id = $(this).data('id');

                    $.ajax({
                        type: "GET",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('get_document', ['id' => ':id'])); ?>"
                            .replace(':id', id),
                        success: function(response) {

                            if (response.status === 404) {
                                $('#updateDocument').modal('hide');
                                toastr.error('Document not found.');
                            } else {
                                $('#updateDocument').modal('show');
                                var document =
                                    response; // response is already the department data
                                $('#document_id').val(document.id);
                                $('#update_name').val(document.name);
                                $('#update_remind_date').val(document.remind_date);
                            }
                        },
                        error: function(xhr) {

                            toastr.error('An error occurred while fetching the Document.');
                        }
                    });
                });
                $('#updateDocumentForm').on('submit', function(e) {
                    e.preventDefault();

                    var id = $('#document_id').val(); // Get the document ID

                    let $submitButton = $('#updateDocumentForm button[type="submit"]');
                    $submitButton.prop('disabled', true); // Disable the submit button

                    let formData = new FormData(this); // Use FormData to handle file upload

                    $.ajax({
                        type: 'POST',
                        url: "<?php echo e(route('update_document_form', ['id' => ':id'])); ?>".replace(':id', id),
                        data: formData,
                        contentType: false, // Required for file uploads
                        processData: false, // Required for file uploads
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function(response) {
                            if (response.success) {
                                $('#updateDocument').modal('hide');
                                $('#document_table').DataTable().ajax.reload(); // Reload DataTable
                                toastr.success(response.message);
                                $('#updateDocumentForm')[0].reset(); // Reset form
                            } else {
                                toastr.error(response.message || 'An error occurred.');
                            }
                        },
                        error: function(xhr) {
                            let errorMessage = 'An unexpected error occurred.';
                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorMessage = xhr.responseJSON.message;
                            }
                            toastr.error(errorMessage);
                        },
                        complete: function() {
                            $submitButton.prop('disabled', false); // Re-enable the submit button
                        }
                    });
                });



            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\devioo_hrm\resources\views/admin/settings/document.blade.php ENDPATH**/ ?>