<?php $__env->startSection('content'); ?>
    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    Leave List
                </h3>
                <nav class="col-md-6 text-right" aria-label="breadcrumb">
                    <form id="getTotalLeaves" method="GET">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="user_id_leaves" id="user_id_leaves" value="<?php echo e(session('id')); ?>">
                        <button data-bs-toggle="modal" id="add_leave" class="btn btn-sm btn-outline-primary">
                            <i class="fa fa-plus-circle mr-sm-2"></i>Create Leave
                        </button>
                    </form>
                </nav>
                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a
                                style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Leave List
                        </li>
                    </ol>
                </nav>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table id="leave_table" class="data_table table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>id</th>
                                            <th>Leave Type</th>
                                            <th>Leave Status</th>
                                            <th>Start Date</th>
                                            <th>End Date</th>
                                            <th>Reason</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>




    <div class="modal fade" id="createLeave" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Add Leave</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <span class="d-flex p-2">
                    <h5 style="padding: 2px 7px;">Remaining Paid Leaves</h5> :
                    <span id="remainingLeaves" class="ps-2"> 0 </span>  /  <span id="totalLeaves"> 0 </span>
                </span>
                <form id="addLeaveForm" method="POST" style="margin-top: -7px;">
                    <div class="modal-body" style="padding: 5px 15px !important">
                        <?php echo csrf_field(); ?>
                        <label for="">Leave Type</label>
                        <select type="text" class="form-control leavyType" id="leave_type_id" name="leave_type_id" required>
                            <option selected disabled>Select Leave Type</option>
                            <?php $__currentLoopData = $leave_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $leave_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($leave_type['id']); ?>"><?php echo e($leave_type['name']); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>

                        <label class="mt-4">Start Date</label>
                        <input class="form-control" type="date" id="start_date" name="start_date"
                            placeholder="Enter start date" required></input>
                        <label class="mt-4">End Date</label>
                        <input class="form-control" type="date" id="end_date" name="end_date"
                            placeholder="Enter end  date" required></input>

                        <label class="mt-4">Reason</label>
                        <textarea class="form-control" type="text" id="reason" name="reason" rows="5" placeholder="Enter Reason"
                            required></textarea>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Add</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="updateLeave" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Update Leave</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="updateLeaveForm">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        <?php echo csrf_field(); ?>
                        <input type="hidden aaa" name="leave_id" id="leave_id">
                        <label for="">Leave Type</label>
                        <select type="text" class="form-control leavyType" id="update_leave_type_id" name="leave_type_id"
                            required>
                            <option selected disabled>Select Leave Type</option>
                            <?php $__currentLoopData = $leave_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $leave_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($leave_type['id']); ?>"><?php echo e($leave_type['name']); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <label class="mt-4">Start Date</label>
                        <input class="form-control" type="date" id="update_start_date" name="start_date"
                            placeholder="Enter start date" required></input>
                        <label class="mt-4">End Date</label>
                        <input class="form-control" type="date" id="update_end_date" name="end_date"
                            placeholder="Enter end  date" required></input>

                        <label class="mt-4">Reson</label>
                        <textarea class="form-control" type="text" id="update_reason" name="reason" rows="5"
                            placeholder="Enter reason" required></textarea>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Update</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php $__env->startPush('js'); ?>
        <script>
            $(document).ready(function() {
              

                var session_data = <?php echo json_encode(session()->all(), 15, 512) ?>;
                $('#leave_table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: '<?php echo e(env('API_BASE_URL')); ?>/leaves/index',
                        beforeSend: function(xhr) {
                            xhr.setRequestHeader('Authorization', session_data.bearer_token);
                        },
                        complete: function(response) {
                            // After the API call is complete, restore the session data
                            if (response.status === 200) {
                                $.ajax({
                                    type: 'GET',
                                    url: '<?php echo e(route('restore_session_data')); ?>',
                                    data: {
                                        bearer_token: session_data.bearer_token,
                                        role: session_data.role,
                                        permissions: session_data.permissions,
                                        org_id: session_data.org_id,
                                        id: session_data.id,
                                        logo: session_data.logo,
                                        employee_id: session_data.employee_id,
                                        user_name: session_data.user_name,
                                        designation: session_data.designation,
                                    },
                                    success: function(data) {
                                        if (data.success) {
                                            console.log("Session restored successfully");
                                        } else {
                                            console.error("Failed to restore session");
                                        }
                                        console.log(data);
                                    },
                                    error: function(xhr) {
                                        console.error("Error restoring session:", xhr);
                                    }
                                });

                            }
                        }
                    },
                    columns: [{
                            data: 'count',
                            name: 'count'
                        },
                        {
                            data: 'id',
                            name: 'id',
                            visible: false
                        },
                       
                        {
                            data: 'leave_type',
                            name: 'leave_type'
                        },
                        {
                            data: 'leave_status',
                            name: 'leave_status',
                            render: function(data, type, row) {
                                if (data === 'paid') {
                                    return `<span class="text-white badge badge-pill fw-bold badge bg-success">Paid</span>`;
                                } else if (data === 'unpaid') {
                                    return `<span class="text-white badge badge-pill fw-bold badge bg-danger">Unpaid</span>`;
                                } else if (data === 'reject') {
                                    return `<span class="text-white badge badge-pill fw-bold badge bg-danger">Rejected</span>`;
                                } else if (data === 'processing') {
                                    return `<span class="text-white badge badge-pill fw-bold badge bg-warning">Processing</span>`;
                                }
                                return data; // Default case if the status is something unexpected
                            }
                        },

                        {
                            data: 'start_date',
                            name: 'start_date',
                            render: function(data) {
                                return new Date(data).toLocaleDateString('en-GB', {
                                    day: '2-digit',
                                    month: 'short',
                                    year: 'numeric'
                                });
                            }
                        },
                        {
                            data: 'end_date',
                            name: 'end_date',
                            render: function(data) {
                                return new Date(data).toLocaleDateString('en-GB', {
                                    day: '2-digit',
                                    month: 'short',
                                    year: 'numeric'
                                });
                            }
                        },

                        {
                            data: 'reason',
                            name: 'reason'
                        },
                        {
                            data: 'status',
                            name: 'status',
                            render: function(data, type, row) {
                                if (data === 'approve') {
                                    return `<span class="text-white badge badge-pill fw-bold badge bg-success">Approved</span>`;
                                } else if (data === 'reject') {
                                    return `<span class="text-white badge badge-pill fw-bold badge bg-danger">Rejected</span>`;
                                } else if (data === 'pending') {
                                    return `<span class="text-white badge badge-pill fw-bold badge bg-warning">Pending</span>`;
                                }
                                return data; // Default case if the status is something unexpected
                            }
                        },



                        {
                            data: null,
                            name: 'action',
                            render: function(data, type, row) {
                                return `
                        <div class="dropdown">
                            <a style="font-size: 19px; color:black; text-decoration: none;" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                ⋮
                            </a>

                            <div class="dropdown-menu"  aria-labelledby="dropdownMenuLink" x-placement="bottom-start" style="position: absolute; transform: translate3d(0px, 21px, 0px); top: 0px; left: 0px; will-change: transform;">
                                <button data-id="${row.id}" id="editleavetbtn"  class="dropdown-item text-primary">
                                    <i class="fa fa-pen mr-2"></i> Edit
                                </button>
                               
                            </div>
                        </div>
                    `;
                            }
                        }
                    ]
                });


                $('#add_leave').on('click', function(e) {
                    e.preventDefault(); // Prevent the form from submitting

                    var id = $('#user_id_leaves').val();
                    // Make AJAX request to fetch the total and remaining leaves
                    $.ajax({
                        url: "<?php echo e(route('get_total_leaves', ['id' => ':id'])); ?>".replace(':id', id),
                        method: 'GET',
                        success: function(response) {
                            if (response.success) {
                                // Update the span with the fetched leaves data
                                $('#remainingLeaves').text(response.remaining_leaves);
                                $('#totalLeaves').text(response.total_allocated_leaves);

                                // Show the modal after data is fetched and updated
                                $('#createLeave').modal('show');
                            } else {
                                toastr.error(response.message);
                            }
                        },
                        error: function(xhr, status, error) {
                            toastr.error('An error occurred while fetching the leaves data.');
                        }
                    });
                });
                $('#addLeaveForm').on('submit', function(e) {
                    e.preventDefault();
                    var leavyType = $('.leavyType').val();
                    if (!leavyType) {
                        toastr.error('Please select an Leave Type.');
                        $submitButton.prop('disabled', false); // Re-enable the submit button
                        return;
                    }
                    let $submitButton = $('#addLeaveForm button[type="submit"]');
                    $submitButton.prop('disabled', true);

                    $.ajax({
                        type: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('add_leave_form')); ?>",
                        data: $(this).serialize(),
                        success: function(response) {
                            if (response.success) {
                                $('#createLeave').modal('hide');
                                $('#leave_table').DataTable().ajax.reload();
                                $('#addLeaveForm')[0].reset();
                                toastr.success(response.message);
                            } else {
                                // Display the first validation error only
                                let firstError = null;

                                if (response.errors) {
                                    $.each(response.errors, function(key, errors) {
                                        // Take the first error message of the first field that has an error
                                        firstError = errors[0];
                                        return false; // Break out of loop after the first error
                                    });
                                }

                                if (firstError) {
                                    toastr.error(firstError);
                                } else {
                                    toastr.error(response.message || 'An error occurred.');
                                }
                            }
                        },
                        error: function(xhr) {
                            console.log("AJAX Error:", xhr);
                            toastr.error(
                                'The End Date must be After Start Date.'); // General error message
                        },
                        complete: function() {
                            $submitButton.prop('disabled', false);
                        }
                    });
                });



                $('body').on('click', '#editleavetbtn', function() {
                    var id = $(this).data('id');
                    $.ajax({
                        type: "GET",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('get_leave', ['id' => ':id'])); ?>"
                            .replace(':id', id),
                        success: function(response) {

                            if (response.status === 404) {
                                $('#updateLeave').modal('hide');
                                toastr.error('Leave not found.');
                            } else {
                                $('#updateLeave').modal('show');
                                var leave =
                                    response;
                                console.log(leave); // response is already the department data
                                $('#leave_id').val(leave.id);

                                $('#update_leave_type_id').val(leave.leave_type_id);
                                $('#update_start_date').val(leave.start_date);
                                $('#update_end_date').val(leave.end_date);

                                $('#update_reason').val(leave.reason);
                            }
                        },
                        error: function(xhr) {

                            toastr.error('An error occurred while fetching the Leave .');
                        }
                    });
                });

                $('#updateLeaveForm').on('submit', function(e) {
                    e.preventDefault();

                    var id = $('#leave_id').val(); // Ensure the correct leave ID is set

                    let $submitButton = $('#updateLeaveForm button[type="submit"]');
                    $submitButton.prop('disabled', true); // Disable button during request

                    $.ajax({
                        type: 'PUT',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('update_leave_form', ['id' => ':id'])); ?>".replace(':id', id),
                        data: $(this).serialize(), // Send form data
                        success: function(response) {
                            if (response.success) {
                                $('#updateLeave').modal('hide');
                                $('#leave_table').DataTable().ajax.reload(); // Reload DataTable
                                toastr.success(response.message); // Show success message
                                $('#updateLeaveForm')[0].reset(); // Reset the form
                            } else {
                                let errorMessage = response.message || 'An error occurred.';
                                toastr.error(errorMessage); // Show error message
                            }
                        },
                        error: function(xhr) {
                            let errorMessage = 'An unexpected error occurred.';
                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorMessage = xhr.responseJSON.message;
                            }
                            toastr.error(errorMessage); // Display the error message
                        },
                        complete: function() {
                            $submitButton.prop('disabled', false); // Re-enable the button
                        }
                    });
                });



            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/microsolscom/public_html/devioo-hrm/resources/views/admin/employee/leave.blade.php ENDPATH**/ ?>