<?php $__env->startSection('content'); ?>
    <style>
        .loader {
            display: none;
            border: 4px solid #f3f3f3;
            border-top: 4px solid #3498db;
            border-radius: 50%;
            width: 20px;
            height: 20px;
            animation: spin 2s linear infinite;
            margin-left: 10px;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }
    </style>

    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    Employee List
                </h3>
                <nav class="col-md-6 text-right" aria-label="breadcrumb">
                    <a href="<?php echo e(route('create_employee')); ?>" data-bs-toggle="modal" id="add_user"
                        class="btn btn-sm btn-outline-primary">
                        <i class="fa fa-plus-circle mr-sm-2"></i>Create Employee
                    </a>
                    <a href="#" data-bs-toggle="modal" id="add_csv" class="btn btn-sm btn-outline-primary">
                        <i class="fa fa-plus-circle mr-sm-2"></i>Upload CSV
                    </a>
                    <a href="<?php echo e(asset('sample.csv')); ?>" class="btn btn-sm btn-outline-primary" download>
                        <i class="fa fa-download mr-sm-2"></i>Sample CSV
                    </a>

                </nav>
                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Employee List</li>
                    </ol>
                </nav>
            </div>

            <div class="modal fade" id="uploadCsv" tabindex="-1" role="dialog" aria-labelledby="uploadModalLabel"
                aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="uploadModalLabel">Upload Payslip CSV</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <form id="uploadPayslipForm" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label for="csv_file">Select CSV File</label>
                                    <input type="file" class="form-control" id="csv_file" name="csv_file" required>
                                    <!-- Div to show error messages -->
                                    <div id="fileError" class="text-danger mt-2" style="display: none;"></div>
                                </div>
                                <button type="submit" class="btn btn-primary">
                                    Upload
                                    <div class="loader" id="loader" style="display: none;"></div>
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>


            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table id="employee_table" class="data_table table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>id</th>
                                            <th>Image</th>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Department</th>
                                            <th>Designation</th>
                                            <th>Phone</th>
                                            <th>Address</th>
                                            <th>Salary Slip</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal for selecting month and additional options -->
    <div class="modal fade" id="salarySlipModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Generate Salary Slip</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="previewForm" action="<?php echo e(route('fetch_paid_salary')); ?>" style="display: none;">
                        <input type="hidden" name="employee_id" id="employee_id_preview" class="form-control" required>

                        <div class="form-group">
                            <label for="month">Month:</label>
                            <input type="month" name="month" id="month_preview" class="form-control" required>
                        </div>

                        <!-- Preview Salary Slip Button -->
                        <button type="submit" id="previewButton" class="btn btn-primary">Preview Salary Slip</button>
                    </form>
                    <form id="generateForm" method="GET">
                        <input type="hidden" name="employee_id" id="employee_id" class="form-control" required>

                        <div class="form-group">
                            <label for="month">Month:</label>
                            <input type="month" name="month" id="month" class="form-control" required>
                        </div>

                        <div class="row">
                            <div class="col-6">
                                <!-- Deductions Toggle -->
                                <div class="form-group">
                                    <label for="deductions">Deductions:</label>
                                    <input type="checkbox" id="deductions" name="deductions" checked>
                                </div>

                                <!-- Loans Toggle -->
                                <div class="form-group">
                                    <label for="loans">Loans:</label>
                                    <input type="checkbox" id="loans" name="loans" checked>
                                </div>
                            </div>
                            <div class="col-6">
                                <!-- Tax Toggle -->
                                <div class="form-group">
                                    <label for="tax">Tax:</label>
                                    <input type="checkbox" id="tax" name="tax" checked>
                                </div>

                                <!-- Leave Deductions Toggle -->
                                <div class="form-group">
                                    <label for="leave_deductions">Leave Deductions:</label>
                                    <input type="checkbox" id="leave_deductions" name="leave_deductions" checked>
                                </div>
                            </div>
                        </div>

                        <!-- Salary Comment Textarea -->
                        <div class="form-group">
                            <label for="salary_comment">Salary Comment:</label>
                            <textarea name="salary_comment" id="salary_comment" class="form-control" placeholder="Optional comments"></textarea>
                        </div>

                        <button type="submit" class="btn btn-primary">Generate Salary Slip</button>
                    </form>
                </div>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        $(document).ready(function() {
          
            var session_data = <?php echo json_encode(session()->all(), 15, 512) ?>;

            $('#employee_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '<?php echo e(env('API_BASE_URL')); ?>/employees/index',
                    beforeSend: function(xhr) {
                        xhr.setRequestHeader('Authorization', session_data.bearer_token);
                    },
                    complete: function(response) {
                        // After the API call is complete, restore the session data
                        if (response.status === 200) {
                            $.ajax({
                                type: 'GET',
                                url: '<?php echo e(route('restore_session_data')); ?>',
                                data: {
                                    bearer_token: session_data.bearer_token,
                                    role: session_data.role,
                                    permissions: session_data.permissions,
                                    org_id: session_data.org_id,
                                    id: session_data.id,
                                    currency: session_data.currency,
                                    logo: session_data.logo,
                                    employee_id: session_data.employee_id,
                                    user_name: session_data.user_name,
                                    designation: session_data.designation,
                                },
                                success: function(data) {
                                    if (data.success) {
                                        console.log("Session restored successfully");
                                    } else {
                                        console.error("Failed to restore session");
                                    }
                                    console.log(data);
                                },
                                error: function(xhr) {
                                    console.error("Error restoring session:", xhr);
                                }
                            });

                        }
                    }
                },
                columns: [{
                        data: 'count',
                        name: 'count'
                    },
                    {
                        data: 'id',
                        name: 'id',
                        visible: false
                    },
                    {
                        data: 'user_profile.image',
                        name: 'image',
                        render: function(data, type, row) {
                            // Construct the image URL using the environment variable
                            const apiUrlForImage = '<?php echo e(env('API_URL_FOR_IMAGE')); ?>';
                            const imageUrl = apiUrlForImage + '/' +
                            data; // Ensure the URL is correct

                            return '<img src="' + imageUrl +
                                '" alt="Employee Image" style="width:50px; height:50px;"/>';
                        },
                        orderable: false // Disable sorting for the image column
                    },
                    {
                        data: 'user_profile.user.name',
                        name: 'name'
                    },
                    {
                        data: 'user_profile.user.email',
                        name: 'email'
                    },
                    {
                        data: 'department.department',
                        name: 'department'
                    },
                    {
                        data: 'designation.designation',
                        name: 'designation'
                    },
                    {
                        data: 'user_profile.phone',
                        name: 'phone'
                    },
                    {
                        data: 'user_profile.address',
                        name: 'address'
                    },
                    {
                        data: null,
                        name: 'Salary Slip',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row) {
                            return `<a role="button" data-id="${row.id}" class="btn btn-warning salarySlipBtn">Salary Slip</a>`;
                        }
                    },
                    {
                        data: null,
                        name: 'action',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row) {
                            var updateEmployeeUrl = "<?php echo e(route('update_employee', ':id')); ?>".replace(
                                ':id', row.id);
                            return `
                    <div class="dropdown">
                        <a style="font-size: 19px; color:black; text-decoration: none;" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            ⋮
                        </a>
                        <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                            <a href="${updateEmployeeUrl}" class="dropdown-item text-primary editEmployeeBtn">
                                <i class="fa fa-pen mr-2"></i> Edit
                            </a>
                           
                        </div>
                    </div>
                    `;
                        }
                    }
                ],

                dom: '<"top"lfrB>rt<"bottom"ip><"clear">',
                buttons: [{
                    extend: 'csvHtml5',
                    text: '<i class="fas fa-download"></i>',
                    title: 'Employees',
                    exportOptions: {
                        columns: [0, 2, 3, 4, 5, 6, 7]
                    }
                }]
            });


            $('body').on('click', '#delete_employee', function() {
                var id = $(this).data('id');

                $.ajax({
                    type: "DELETE",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: "<?php echo e(route('delete_employee', ['id' => ':id'])); ?>"
                        .replace(':id', id),
                    success: function(response) {
                        $('#employee_table').DataTable().ajax.reload();
                        // Show success Toastr message
                        toastr.success('Employee deleted successfully');
                    },
                    error: function(xhr) {
                        // Display error Toastr message
                        let errorMessage = 'An error occurred while deleting the Employee.';
                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            errorMessage = xhr.responseJSON.message;
                        }
                        toastr.error(errorMessage);
                    }
                });
            });

            var employeeId;

            // Show modal and set employee ID
            $('#employee_table').on('click', '.salarySlipBtn', function() {
                employeeId = $(this).data('id');
                $('#employee_id').val(employeeId);
                $('#salarySlipModal').modal('show');
                $('#generateForm').show();
                $('#previewForm').hide();
            });

            $('#add_csv').on('click', function() {
                $('#uploadCsv').modal('show');
                $('#uploadPayslipForm')[0].reset();
            });
            $('#uploadPayslipForm').on('submit', function(e) {
                e.preventDefault(); // Prevent the default form submission

                // Create FormData object
                var formData = new FormData(this);

                // Show the loader and disable the button
                $('#loader').show();
                const submitButton = $(this).find('button[type="submit"]');
                const originalButtonText = submitButton.text(); // Store the original button text
                submitButton.prop('disabled', true).text(
                    'Uploading...'); // Disable the button and change the text

                // Clear previous error messages
                $('#fileError').hide().text('');

                // Make AJAX request
                $.ajax({
                    url: "<?php echo e(route('upload_csv')); ?>",
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        // Check if there are errors in the response
                        if (response.errors && response.errors.length > 0) {
                            // Format error messages with numbering
                            let errorMessages = response.errors.map((error, index) =>
                                `${index + 1}. ${error}`).join('<br>');

                            // Show error messages directly under the input
                            $('#fileError').show().html(errorMessages);
                            toastr.error(
                                "Please fix the errors before uploading."
                            ); // Display toast for additional feedback
                        } else {
                            // Show success message
                            toastr.success(response.message);

                            // Close the modal
                            $('#uploadCsv').modal('hide');
                        }
                    },
                    error: function(xhr) {
                        // Show error message directly from the API response
                        const errors = xhr.responseJSON.errors;

                        let errorMessage = 'An error occurred: ';
                        if (errors) {
                            // Format error messages with numbering
                            errorMessage += errors.map((error, index) =>
                                `${index + 1}. ${error}`).join('<br>');
                        } else {
                            errorMessage += xhr.responseJSON.message || 'Something went wrong!';
                        }

                        // Show errors under the input
                        $('#fileError').show().html(errorMessage);
                        toastr.error(errorMessage); // Display error message in a toast
                    },
                    complete: function() {
                        // Hide the loader and re-enable the button
                        $('#loader').hide();
                        submitButton.prop('disabled', false).text(
                            originalButtonText); // Reset the button text
                    }
                });
            });





            document.addEventListener('DOMContentLoaded', function() {
                // Function to handle toggles
                function handleToggle(toggleElement) {
                    toggleElement.addEventListener('change', function() {
                        this.value = this.checked ? 'on' :
                            'off'; // Set value based on checked state
                    });
                }

                // Select the toggles
                const deductionsToggle = document.getElementById('deductions');
                const loansToggle = document.getElementById('loans');
                const taxToggle = document.getElementById('tax');
                const leaveDeductionsToggle = document.getElementById('leave_deductions');

                // Attach the event listener to each toggle
                handleToggle(deductionsToggle);
                handleToggle(loansToggle);
                handleToggle(taxToggle);
                handleToggle(leaveDeductionsToggle);
            });

            $('#generateForm').submit(function(e) {
                e.preventDefault(); // Prevent default form submission

                let employeeId = $('#employee_id').val();
                let month = $('#month').val();

                // Get values based on checkbox state
                let deductions = $('#deductions').is(':checked') ? 'on' : 'off';
                let loans = $('#loans').is(':checked') ? 'on' : 'off';
                let tax = $('#tax').is(':checked') ? 'on' : 'off';
                let leaveDeductions = $('#leave_deductions').is(':checked') ? 'on' : 'off';
                let salaryComment = $('#salary_comment').val();

                let $submitButton = $('#generateForm button[type="submit"]');
                $submitButton.prop('disabled', true); // Disable button to prevent multiple submissions

                $.ajax({
                    url: "<?php echo e(route('fetchPayslip')); ?>", // Route for generating payslip
                    type: 'GET',
                    data: {
                        employee_id: employeeId,
                        month: month,
                        deductions: deductions,
                        loans: loans,
                        tax: tax,
                        leave_deductions: leaveDeductions,
                        salary_comment: salaryComment
                    },
                    success: function(response) {
                        console.log(response.data)
                        if (response.payment_status === 'paid') {
                            // Hide the generate form and show the preview form
                            $('#generateForm').hide();
                            $('#previewForm').show();

                            // Update hidden fields for preview form
                            $('#employee_id_preview').val(employeeId);
                            $('#month_preview').val(month);
                        } else {
                            toastr.success("Processing Salary Slip"); // Display success message
                            generateUnpaidPayslip();
                        }
                    },
                    error: function(xhr) {
                        toastr.error(
                            "The requested month is not the next month after the employee's joining date."
                            );
                        console.log(xhr.responseText);
                    },
                    complete: function() {
                        $submitButton.prop('disabled',
                            false); // Re-enable the submit button after the request completes
                    }
                });
            });

            function generateUnpaidPayslip() {
                let employeeId = $('#employee_id').val();
                let month = $('#month').val();

                // Get values based on checkbox state
                let deductions = $('#deductions').is(':checked') ? 'on' : 'off';
                let loans = $('#loans').is(':checked') ? 'on' : 'off';
                let tax = $('#tax').is(':checked') ? 'on' : 'off';
                let leaveDeductions = $('#leave_deductions').is(':checked') ? 'on' : 'off';
                let salaryComment = $('#salary_comment').val();

                // Redirect to the generate_unpaid_payslip route with query parameters
                let url = "<?php echo e(route('generate_unpaid_payslip')); ?>?" + $.param({
                    employee_id: employeeId,
                    month: month,
                    deductions: deductions,
                    loans: loans,
                    tax: tax,
                    leave_deductions: leaveDeductions,
                    salary_comment: salaryComment
                });

                window.location.href = url;
            }


            $('#previewButton').click(function() {
                let employeeId = $('#employee_id_preview').val();
                let month = $('#month_preview').val();

                toastr.info('Previewing salary slip for employee ' + employeeId + ' for the month of ' +
                    month);
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/microsolscom/public_html/devioo-hrm/resources/views/admin/employee/employee.blade.php ENDPATH**/ ?>