<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Settings\Document;
use Illuminate\Support\Facades\Mail;
use Carbon\Carbon;

class SendReminderEmails extends Command
{
    protected $signature = 'send:reminders';
    protected $description = 'Send reminder emails for documents expiring within the configured reminder period';

    public function handle()
    {
        // Get the current date
        $today = Carbon::now();

        // Get all documents
        $documents = Document::all();

        foreach ($documents as $document) {
            // Calculate the reminder date based on expiry_date and remind_before
            $remindDate = Carbon::createFromFormat('Y-m-d', $document->expiry_date)->subDays($document->remind_before);

            // Check if today's date is the reminder date or later
            if ($today->isSameDay($remindDate) || $today->isAfter($remindDate)) {
                // Get employee email from related UserProfile
                $employeeEmail = $document->userProfile->user->email;

                // Admin email (set this to your actual admin email)
                $adminEmail = 'musharraf5200@gmail.com';

                // Prepare the email content
                $emailContent = [
                    'documentName' => $document->name,
                    'expiryDate' => $document->expiry_date,
                ];

                // Send email to the employee
                Mail::send('emails.reminder', $emailContent, function ($message) use ($employeeEmail) {
                    $message->to($employeeEmail)
                            ->subject('Document Expiration Reminder');
                });

                // Send email to the admin
                Mail::send('emails.reminder', $emailContent, function ($message) use ($adminEmail) {
                    $message->to($adminEmail)
                            ->subject('Document Expiration Reminder');
                });
            }
        }

        $this->info('Reminder emails sent successfully!');
    }
}
