<?php

namespace App\Models\Settings;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Department extends Model
{
    use HasFactory;
    protected $table = 'departments';
    protected $fillable = [
        'department',
      'org_id'
    ];

    // protected $hidden = [
    //     'created_at',
    //     'updated_at',
    // ];
    public function employees()
    {
        return $this->hasMany(Employee::class, 'department_id');
    }
    public function designations()
    {
        return $this->hasMany(Designation::class, 'department_id');
    }

}
