<?php

namespace App\Models\Settings;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Payment extends Model
{
    use HasFactory;

    protected $table = 'payments';

    protected $fillable = [
        'org_id',
        'employee_id',
        'allowances',
        'increments',
        'deductions',
        'loan_amount',
        'loan_installment',
        'bonus_amount',
        'unpaid_leaves',
        'leave_deduction',
        'net_pay',
        'tax',
        'net_pay_after_tax',
        'days',
        'salary_month',
        'salary_comment',
        'salary'
    ];

    // Relationships


    public function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id');
    }


    public function organization()
    {
        return $this->belongsTo(Organization::class, 'org_id');
    }

  
}
