<?php

namespace App\Models\Settings;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WorkHistory extends Model
{
    use HasFactory;

    protected $table = 'work_histories';
    protected $fillable = [
        'org_id',
        'employee_id',
        'company_name',
        'designation',
        'joining_date',
        'leaving_date',
        'reason'
    ];


    public function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id');
    }
}
