@extends('admin.layout.main')

@section('content')
<style>
    .expense_btn {
        border: none;
        cursor: pointer;
    }

   
</style>
    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    Expense Request List
                </h3>
               
                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a
                                style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Expense Request List
                        </li>
                    </ol>
                </nav>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table id="income_table" class="data_table table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Employee</th>
                                            <th>Amount</th>
                                            <th>Date</th>
                                            <th>Description</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>




  


    @push('js')
        <script>
            $(document).ready(function() {
                $('#income_table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: '{{ route('employee_expense_request') }}',
                    columns: [{
                            data: 'id',
                            name: 'id'
                        },
                        {
                            data: 'user_name',
                            name: 'user_name'
                        },
                        {
                            data: 'amount',
                            name: 'amount'
                        },

                        {
                            data: 'date',
                            name: 'date',
                            render: function(data) {
                                return new Date(data).toLocaleDateString('en-GB', {
                                    day: '2-digit',
                                    month: 'short',
                                    year: 'numeric'
                                });
                            }
                        },
                        {
                            data: 'description',
                            name: 'description'
                        },
                        {
                            data: null,
                            name: 'status',
                            render: function(data, type, row) {
                                let approveUrl = `{{ route('expense_approve', ':id') }}`.replace(':id',
                                    row
                                    .id);
                                let rejectUrl = `{{ route('expense_reject', ':id') }}`.replace(':id',
                                    row
                                    .id); // Dynamic URL for rejection

                                if (row.status === 'pending') {
                                    return `
                <div class="d-flex p-10 ">
                     <form action="${approveUrl}" method="POST">
                         @csrf
                        @method('PUT')
                        <input type="hidden" name="user_id" value="${row.id}">
                     <button type="submit"  class="expense_btn text-white badge badge-pill fw-bold badge bg-success mr-2">Approve</button>
                     </form>
                    <form action="${rejectUrl}" method="POST">
                        @csrf
                        @method('PUT')
                        <input type="hidden" name="user_id" value="${row.id}">
                        <button  type="submit" class="expense_btn text-white badge badge-pill fw-bold badge bg-danger ">Reject</button>
                    </form>
                </div>
            `;
                                } else if (row.status === 'approve') {
                                    return `<span class="text-white badge badge-pill fw-bold badge bg-success">Approved</span>`;
                                } else if (row.status === 'reject') {
                                    return `<span class="text-white badge badge-pill fw-bold badge bg-danger">Rejected</span>`;
                                }
                            }
                        }

                    ]
                });
            });
        </script>
    @endpush
@endsection
