@extends('admin.layout.main')

@section('content')
    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    Tax Slab List
                </h3>
                <nav class="col-md-6 text-right" aria-label="breadcrumb">
                    <button data-bs-toggle="modal" id="add_tax_slab" class="btn btn-sm btn-outline-primary">
                        <i class="fa fa-plus-circle mr-sm-2"></i>Create Tax Slab</button>
                </nav>
                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a
                                style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;"> Tax Slab List
                        </li>
                    </ol>
                </nav>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table id="tax_slab_table" class="data_table table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Tax (%)</th>
                                            <th>Tax Slab (Rs)</th>
                                            <th>Flat Tax (Rs)</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>




    <div class="modal fade" id="createTaxSlab" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Add Tax Slab</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="addTaxSlabForm" method="POST">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        @csrf


                        <label>Tax</label>
                        <input class="form-control" type="number" id="tax" name="tax" placeholder="Enter tax"
                            required></input>
                        <small id="emailHelp" class="form-text text-muted">(This will be consider as %) </small>

                        <label class="mt-4">Tax Slab</label>
                        <input class="form-control" type="number" id="tax_slab" name="tax_slab"
                            placeholder="Enter tax slab" required></input>
                        <label class="mt-4">Flat Tax</label>
                        <input class="form-control" type="number" id="flat_tax" name="flat_tax"
                            placeholder="Enter Flat Tax" required></input>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Add</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="updateTaxSlab" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Update Tax Slab</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="updateTaxSlabForm">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        @csrf
                        <input type="hidden" name="tax_slab_id" id="tax_slab_id">

                        <label>Tax</label>
                        <input class="form-control" type="number" id="update_tax" name="tax" placeholder="Enter tax"
                            required></input>
                        <small id="emailHelp" class="form-text text-muted">(This will be consider as %) </small>

                        <label class="mt-4">Tax Slab</label>
                        <input class="form-control" type="number" id="update_tax_slab" name="tax_slab"
                            placeholder="Enter tax slab" required></input>
                        <label class="mt-4">Flat Tax</label>
                        <input class="form-control" type="number" id="update_flat_tax" name="flat_tax"
                            placeholder="Enter Flat Tax" required></input>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Update</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    @push('js')
        <script>
            $(document).ready(function() {
                $('#tax_slab_table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: '{{ route('tax_slab_list') }}',
                    columns: [{
                            data: 'id',
                            name: 'id'
                        },
                        {
                            data: 'tax',
                            name: 'tax'
                        },
                        {
                            data: 'tax_slab',
                            name: 'tax_slab'
                        },
                        {
                            data: 'flat_tax',
                            name: 'flat_tax'
                        },
                        {
                            data: 'status',
                            name: 'status'
                        },
                        {
                            data: null,
                            name: 'action',
                            render: function(data, type, row) {
                                return `
                        <div class="dropdown">
                            <a style="font-size: 19px; color:black; text-decoration: none;" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                ⋮
                            </a>

                            <div class="dropdown-menu"  aria-labelledby="dropdownMenuLink" x-placement="bottom-start" style="position: absolute; transform: translate3d(0px, 21px, 0px); top: 0px; left: 0px; will-change: transform;">
                                <button data-id="${row.id}" id="editincrementtbtn"  class="dropdown-item text-primary">
                                    <i class="fa fa-pen mr-2"></i> Edit
                                </button>
                                <button data-id="${row.id}" id="updateStatusButton" class="dropdown-item text-danger">
                                    <i class="fa fa-arrow-right mr-2"></i> Change Status
                                </button>
                            </div>
                        </div>
                    `;
                            }
                        }
                    ]
                });


                $('#add_tax_slab').on('click', function() {
                    $('#createTaxSlab').modal('show');
                });
                $('#addTaxSlabForm').on('submit', function(e) {
                    e.preventDefault();

                    let $submitButton = $('#addTaxSlabForm button[type="submit"]');
                    $submitButton.prop('disabled', true);

                    $.ajax({
                        type: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('add_tax_slab_form') }}",
                        data: $(this).serialize(),
                        success: function(response) {
                            if (response.success) {
                                $('#createTaxSlab').modal('hide');
                                $('#tax_slab_table').DataTable().ajax.reload();
                                $('#addTaxSlabForm')[0].reset();
                                toastr.success(response.message);
                            } else {
                                let errorMessage = response.message;
                                if (response.errors) {
                                    errorMessage += '<br><br>Errors:<ul>';
                                    $.each(response.errors, function(key, errors) {
                                        $.each(errors, function(index, error) {
                                            errorMessage += '<li>' + error +
                                                '</li>';
                                        });
                                    });
                                    errorMessage += '</ul>';
                                }
                                toastr.error(errorMessage);
                            }
                        },
                        error: function(xhr) {
                            console.log("AJAX Error:", xhr);
                            toastr.error('Invalid Details '); // General error message
                        },
                        complete: function() {
                            $submitButton.prop('disabled', false);
                        }
                    });
                });


                $('body').on('click', '#editincrementtbtn', function() {
                    var id = $(this).data('id');
                    $.ajax({
                        type: "GET",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('get_tax_slab', ['id' => ':id']) }}"
                            .replace(':id', id),
                        success: function(response) {

                            if (response.status === 404) {
                                $('#updateTaxSlab').modal('hide');
                                toastr.error('Tax Slab not found.');
                            } else {
                                $('#updateTaxSlab').modal('show');
                                var tax_slab =
                                    response;

                                $('#tax_slab_id').val(tax_slab.id);
                                $('#update_employee_id').val(tax_slab.empoyee_id);
                                $('#update_tax_slab').val(tax_slab.tax_slab);
                                $('#update_flat_tax').val(tax_slab.flat_tax);

                                $('#update_tax').val(tax_slab.tax);
                            }
                        },
                        error: function(xhr) {

                            toastr.error('An error occurred while fetching the Tax Slab.');
                        }
                    });
                });

                $('#updateTaxSlabForm').on('submit', function(e) {
                    e.preventDefault();

                    var id = $('#tax_slab_id').val(); // Use the correct ID

                    // Disable the submit button to prevent multiple submissions
                    let $submitButton = $('#updateTaxSlabForm button[type="submit"]');
                    $submitButton.prop('disabled', true);

                    $.ajax({
                        type: 'PUT',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('update_tax_slab_form', ['id' => ':id']) }}".replace(':id',
                            id),
                        data: $(this).serialize(),
                        success: function(response) {
                            console.log("AJAX Success:", response); // Log response for debugging

                            if (response.success) {
                                $('#updateTaxSlab').modal('hide');
                                $('#tax_slab_table').DataTable().ajax
                                    .reload(); // Reload DataTable
                                toastr.success(response.message);
                                $('#updateTaxSlabForm')[0].reset();
                            } else {
                                // Handle validation or other errors
                                let errorMessage = response.message || 'An error occurred.';
                                toastr.error(errorMessage); // Display error
                            }
                        },
                        error: function(xhr) {
                            console.log("AJAX Error:", xhr); // Log the error for debugging
                            let errorMessage = 'An unexpected error occurred.';
                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorMessage = xhr.responseJSON.message;
                            }
                            toastr.error(errorMessage); // Display error
                        },
                        complete: function() {
                            // Re-enable the submit button after the request completes
                            $submitButton.prop('disabled', false);
                        }
                    });
                });
                $(document).on('click', '#updateStatusButton', function() {
                    var id = $(this).data('id'); // Get the ID from the clicked button

                    $.ajax({
                        type: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr(
                                'content') // Laravel CSRF token
                        },
                        url: "{{ route('update_tax_slab_status') }}", // Your route for updating the status
                        data: {
                            id: id // Pass the ID as data in the request
                        },
                        success: function(response) {
                            if (response.success) {
                                toastr.success(response.message); // Show success message
                                // Optionally reload table or update UI
                                $('#tax_slab_table').DataTable().ajax.reload();
                            } else {
                                toastr.error(response.message); // Show error message
                            }
                        },
                        error: function(xhr) {
                            let response = xhr.responseJSON || {};
                            toastr.error(response.message || 'An error occurred.');
                        }
                    });
                });
            });
        </script>
    @endpush
@endsection
