@extends('admin.layout.main')

@section('content')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <style>
        .select2-selection__choice{
            padding: 5px !important;
            font-size: 13px !important;
        }
        .select2-selection__rendered{
            padding: 0px 4px 5px 8px;
        }
        .select2-selection{
            padding: 2px 2px 7px 2px;
        }

    </style>
    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    Organization List
                </h3>
                <nav class="col-md-6 text-right" aria-label="breadcrumb">
                    <button data-bs-toggle="modal" id="add_organization" class="btn btn-sm btn-outline-primary">
                        <i class="fa fa-plus-circle mr-sm-2"></i>Create Organization</button>
                </nav>
                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a
                                style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Organization List
                        </li>
                    </ol>
                </nav>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table id="organization_table" class="data_table table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Logo</th>
                                            <th>User </th>
                                            <th>Name</th>
                                            <th>Permissions</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="createOrganization" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Add Organization</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="addOrganizationForm" method="POST" enctype="multipart/form-data">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        @csrf
                        <label for="">Upload Logo (optional)</label>
                        <input class="form-control" type="file" name="image" placeholder="Enter image">

                        <label class="mt-4">Name</label>
                        <input class="form-control" id="name" name="name" placeholder="Enter name" required>

                        <label for="permissions" class="mt-4">Permissions</label>
                        <select name="permissions[]" id="permissions" class="form-control select2" multiple required>
                            <option value="all">All</option>
                            <option value="leave_request">Leave Request</option>
                            <option value="employee">Employee Managment</option>
                            <option value="finance">Finance</option>
                            <option value="settings">Settings</option>
                            <option value="users">Users</option>
                        </select>

                        <label class="mt-4">User</label>
                        <select class="form-control" id="user_id" name="user_id" required>
                            <option disabled selected>Select User</option>
                            @foreach ($users as $user)
                                <option value="{{ $user['id'] }}">{{ $user['name'] }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Add</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>

            </div>
        </div>
    </div>

    <div class="modal fade" id="updateOrganization" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Update Organization</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="updateOrganizationForm" enctype="multipart/form-data">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        @csrf
                        <label>Upload Logo</label>
                        <input type="file" class="form-control" id="update_image" name="image">

                        <label class="mt-4">Name</label>
                        <input class="form-control" id="update_name" name="name" placeholder="Enter name" required>

                        <input type="hidden" name="organization_id" id="organization_id">
                        <label for="permissions" class="mt-4">Permissions</label>
                        <select name="permissions[]" id="update_permissions" class="form-control select2" multiple
                            required>
                            <option value="all">All</option>
                            <option value="leave_request">Leave Request</option>
                            <option value="employee">Employee Managment</option>
                            <option value="finance">Finance</option>
                            <option value="settings">Settings</option>
                            <option value="users">Users</option>
                        </select>

                        <label class="mt-4">Status</label>
                        <select class="form-control" id="update_status" name="status" required>
                            <option disabled selected>Select Status</option>
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Update</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    @push('js')
        <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>


        <script>
            $(".select2").select2({
                width: '100%',
            });
        </script>
        <script>
            $(document).ready(function() {
                $('#organization_table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: '{{ route('organization_list') }}',
                    columns: [{
                            data: 'id',
                            name: 'id'
                        },
                        {
                            data: 'image',
                            name: 'image'
                        },
                        {
                            data: 'user_name',
                            name: 'user_name'
                        },

                        {
                            data: 'name',
                            name: 'name'
                        },
                        {
                            data: 'permissions',
                            name: 'permissions'
                        },
                        {
                            data: 'status',
                            name: 'status'
                        },

                        {
                            data: null,
                            name: 'action',
                            render: function(data, type, row) {
                                return `
                        <div class="dropdown">
                            <a style="font-size: 19px; color:black; text-decoration: none;" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                ⋮
                            </a>

                            <div class="dropdown-menu"  aria-labelledby="dropdownMenuLink" x-placement="bottom-start" style="position: absolute; transform: translate3d(0px, 21px, 0px); top: 0px; left: 0px; will-change: transform;">
                                <button data-id="${row.id}" id="editOrganizationbtn"  class="dropdown-item text-primary">
                                    <i class="fa fa-pen mr-2"></i> Edit
                                </button>
                               <form class="changeStatusForm">
                            @csrf
                            <input type="hidden" id="org_status_id" name="org_status_id" value="${row.id}">
                            <input type="hidden" id="update_status_change" name="status" class="status_input" value="${row.status}"> <!-- Set current status here -->
                            <button data-id="${row.user_id}" data-status="${row.status}" type="button" class="changeStatusButton dropdown-item text-danger">
                                <i class="fa fa-arrow-right mr-2"></i> Change Status
                            </button>
                        </form>
                            </div>
                        </div>
                    `;
                            }
                        }
                    ]
                });

                $('#add_organization').on('click', function() {
                    $('#createOrganization').modal('show');
                });

                $('#addOrganizationForm').on('submit', function(e) {
                    e.preventDefault();

                    let form = $(this)[0];
                    if (!form.checkValidity()) {
                        form.reportValidity();
                        return;
                    }

                    let formData = new FormData(form);
                    let $submitButton = $('#addOrganizationForm button[type="submit"]');
                    $submitButton.prop('disabled', true);

                    $.ajax({
                        type: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('add_organization_form') }}", // Update this route name accordingly
                        data: formData,
                        processData: false,
                        contentType: false,
                        success: function(response) {
                            if (response.success) {
                                $('#createOrganization').modal('hide');
                                $('#organization_table').DataTable().ajax.reload();
                                $('#addOrganizationForm')[0].reset();
                                toastr.success(response.message);
                            } else {
                                let errorMessage = response.message || 'An error occurred.';
                                toastr.error(errorMessage);
                            }
                        },
                        error: function(xhr) {
                            let response = xhr.responseJSON;
                            if (xhr.status === 422 && response.errors) {
                                let firstError = Object.values(response.errors).flat()[0];
                                toastr.error(firstError);
                            } else {
                                toastr.error('An error occurred while adding the organization.');
                            }
                        },
                        complete: function() {
                            $submitButton.prop('disabled', false);
                        }
                    });
                });



                function displayNextError() {
                    if (errorsQueue.length > 0) {
                        displayingError = true;
                        let error = errorsQueue.shift(); // Get the next error message
                        toastr.error(error, '', {
                            onHidden: function() {
                                displayingError = false; // Allow the next error to be displayed
                                // Trigger the form submit again only if there are still errors to show
                                if (errorsQueue.length > 0) {
                                    $('#addOrganizationForm').submit();
                                }
                            }
                        });
                    }
                }

                $('body').on('click', '#editOrganizationbtn', function() {
                    var id = $(this).data('id');

                    $.ajax({
                        type: "GET",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('get_organization', ['id' => ':id']) }}"
                            .replace(':id', id),
                        success: function(response) {

                            if (response.status === 404) {
                                $('#updateOrganization').modal('hide');
                                toastr.error('Organization not found.');
                            } else {
                                $('#updateOrganization').modal('show');
                                var organization =
                                    response; // response is already the department data
                                $('#organization_id').val(organization.id);
                                $('#update_name').val(organization.name);
                                $('#update_status').val(organization.status);
                                $('#update_permissions').val(organization.permissions).trigger('change');
                            }
                        },
                        error: function(xhr) {

                            toastr.error('An error occurred while fetching the Organization.');
                        }
                    });
                });

                $('#updateOrganizationForm').on('submit', function(e) {
                    e.preventDefault();

                    var id = $('#organization_id').val();
                    let $submitButton = $('#updateOrganizationForm button[type="submit"]');
                    $submitButton.prop('disabled', true);

                    var formData = new FormData(this);

                    $.ajax({
                        type: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('update_organization_form', ['id' => ':id']) }}".replace(':id',
                            id),
                        data: formData,
                        processData: false,
                        contentType: false,
                        success: function(response) {
                            console.log("AJAX Success:", response);

                            if (response.success) {
                                $('#updateOrganization').modal('hide');
                                $('#organization_table').DataTable().ajax.reload();
                                toastr.success(response.message);
                                $('#updateOrganizationForm')[0].reset();
                                updateErrorsQueue = [];
                            } else {
                                let errorMessage = response.message || 'An error occurred.';
                                toastr.error(errorMessage);
                            }
                        },
                        error: function(xhr) {
                            let response = xhr.responseJSON;

                            if (xhr.status === 422 && response.errors) {
                                let firstError = Object.values(response.errors).flat()[0];
                                toastr.error(firstError);
                            } else {
                                toastr.error('An error occurred while updating the organization.');
                            }
                        },
                        complete: function() {
                            $submitButton.prop('disabled', false);
                        }
                    });
                });

                function displayNextUpdateError() {
                    if (updateErrorsQueue.length > 0) {
                        updatingError = true;
                        let error = updateErrorsQueue.shift();
                        toastr.error(error, '', {
                            onHidden: function() {
                                updatingError = false;
                                $('#updateOrganizationForm').submit();
                            }
                        });
                    }
                }



                function getBearerToken() {
                    return '{{ session('bearer_token') }}';
                }

                // Handle the "Change Status" button click
                $('body').on('click', '.changeStatusButton', function(e) {
                    e.preventDefault();

                    // Get the parent form of the clicked button
                    var $form = $(this).closest('.changeStatusForm');

                    var orgId = $form.find('#org_status_id').val();
                    var currentStatus = $form.find('.status_input')
                        .val();

                    // Determine the new status
                    var newStatus = (currentStatus === 'active') ? 'inactive' : 'active';
                    $form.find('.status_input').val(
                        newStatus);

                    var token = getBearerToken();

                    $.ajax({
                        type: 'POST',
                        url: "{{ route('update_organization_status_form', ['id' => ':id']) }}".replace(
                            ':id', orgId), // Use orgId here
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                        },
                        data: {
                            status: newStatus,
                        },
                        success: function(response) {
                            // Check if the update was successful
                            if (response.success) {
                                toastr.success('Organization status updated successfully.');



                                // Optionally, you can refresh the table or the UI element
                                $('#organization_table').DataTable().ajax.reload();
                            } else {
                                toastr.error('Failed to update organization status.');
                            }
                        },
                        error: function(xhr, status, error) {
                            toastr.error(
                                'An error occurred while updating the Organization status.');
                            console.error('Error updating organization status:', xhr.responseText,
                                status, error);
                        }
                    });
                });




            });
        </script>
    @endpush
@endsection
