<?php

namespace App\Models\Settings;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Allowance extends Model
{
    use HasFactory;
    protected $table = 'allowances';

    protected $fillable = [
        'name',
        'amount',
        'status',
    ];
    

    public function employees()
    {
        return $this->hasMany(Employee::class, 'allowances_id');
    }
}
