<?php

namespace App\Models\Settings;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Designation extends Model
{
    use HasFactory;
    protected $table = 'designations';

    protected $fillable = [
        'status',
    ];
    // protected $hidden = [
    //     'created_at',
    //     'updated_at',
    // ];
    
    public function department()
    {
        return $this->belongsTo(Department::class);
    }

    public function employees()
    {
        return $this->hasMany(Employee::class, 'designation_id');
    }
}
