<?php

namespace App\Models\Settings;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Education extends Model
{
    use HasFactory;

    protected $table = 'educations';
    protected $fillable = [
      'org_id',
      'employee_id',
      'institute_name',
      'last_degree',
      'campus',
      'session_start',
      'session_end',
      'attach_file',
  ];

  public function employee()
  {
      return $this->belongsTo(Employee::class, 'employee_id');
  }

  public function getAttachFileAttribute($value)
  {
    
      $basePath = 'uploads/files/education/';
      
      return asset($basePath . $value);
  }
}
