<?php

namespace App\Models\Settings;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Loan extends Model
{
    use HasFactory;
    protected $casts = [
        'report' => 'json',
    ];

    protected $fillable = [
        'employee_id',
        'amount',
        'date',
        'reason',
        'terms',
        'installment',
        'status',
        'report',
        'org_id'
    ];

    // Optional: Hidden fields from JSON responses
    // protected $hidden = [
    //     'created_at',
    //     'updated_at',
    // ];

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }
}
