@extends('admin.layout.main')

@section('content')
    <style>
        .leave_btn {
            border: none;
            cursor: pointer;
        }

        #allowLeave {
            height: 28px;
        }
    </style>

    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    Leave List
                </h3>
                <nav class="col-md-6 text-right" aria-label="breadcrumb">
                    <button data-bs-toggle="modal" id="add_leave" class="btn btn-sm btn-outline-primary">
                        <i class="fa fa-plus-circle mr-sm-2"></i>Create Leave</button>
                </nav>
                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a
                                style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Leave List
                        </li>
                    </ol>
                </nav>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table id="leave_table" class="data_table table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>id</th>
                                            <th>leave type id</th>
                                            <th>Employee</th>
                                            <th>Leave Type</th>
                                            <th>Leave Status</th>
                                            <th>Start Date</th>
                                            <th>End Date Date</th>
                                            <th>Reason</th>
                                            <th style="width: 200px">Status</th>

                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="allowLeaveModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Allow Leave</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="allowLeaveForm">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        @csrf

                        <input type="hidden" name="leave_id" id="leave_id">
                        <input type="hidden" name="user_id" id="user_id">
                        <input type="hidden" name="leave_type_id" id="update_leave_type_id">
                        <label for="">Select Leave Status</label>
                        <select name="leave_status" id="leave_status" class="form-control">
                            <option selected disabled>Select Leave Status</option>
                            <option value="paid">Paid</option>
                            <option value="unpaid">Unpaid</option>
                        </select>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Allow</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="createLeave" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Add Leave</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <span class="d-flex p-2">
                    <h5 style="padding: 2px 7px;">Remaining Paid Leaves</h5> :
                    <span id="remainingLeaves" class="ps-2">0</span> / <span id="totalLeaves">0</span>
                </span>
                <form id="addLeaveForm" method="POST">
                    <div class="modal-body" style="padding: 5px 15px !important">
                        @csrf


                        <label for="user_id">Select Employee</label>
                        <select class="form-control" id="user_leave_id" name="user_id" required>
                            <option selected disabled>Select Employee</option>
                            @foreach ($employees as $employee)
                                <option value="{{ $employee['id'] }}">{{ $employee['name'] }}</option>
                            @endforeach
                        </select>
                        <label class="mt-4">Leave Type</label>
                        <select type="text" class="form-control" id="leave_type_id" name="leave_type_id" required>
                            <option selected disabled>Select Leave Type</option>
                            @foreach ($leave_types as $leave_type)
                                <option value="{{ $leave_type['id'] }}">{{ $leave_type['name'] }}</option>
                            @endforeach
                        </select>


                        <label class="mt-4">Start Date</label>
                        <input class="form-control" type="date" id="start_date" name="start_date"
                            placeholder="Enter start date" required></input>
                        <label class="mt-4">End Date</label>
                        <input class="form-control" type="date" id="end_date" name="end_date"
                            placeholder="Enter end  date" required></input>

                        <label class="mt-4">Reason</label>
                        <textarea class="form-control" type="text" id="reason" name="reason" rows="5"
                            placeholder="Enter Reason" required></textarea>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Add</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    @push('js')
        <script>
            $(document).ready(function() {
            
                var session_data = @json(session()->all());
                $('#leave_table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: '{{ env('API_BASE_URL') }}/leaves/index',
                        beforeSend: function(xhr) {
                            xhr.setRequestHeader('Authorization', session_data.bearer_token);
                        },
                        complete: function(response) {
                            // After the API call is complete, restore the session data
                            if (response.status === 200) {
                                $.ajax({
                                    type: 'GET',
                                    url: '{{ route('restore_session_data') }}',
                                    data: {
                                        bearer_token: session_data.bearer_token,
                                        role: session_data.role,
                                        permissions: session_data.permissions,
                                        org_id: session_data.org_id,
                                        id: session_data.id,
                                        currency: session_data.currency,
                                        logo: session_data.logo,
                                        employee_id: session_data.employee_id,
                                        user_name: session_data.user_name,
                                        designation: session_data.designation,
                                    },
                                    success: function(data) {
                                        if (data.success) {
                                            console.log("Session restored successfully");
                                        } else {
                                            console.error("Failed to restore session");
                                        }
                                        console.log(data);
                                    },
                                    error: function(xhr) {
                                        console.error("Error restoring session:", xhr);
                                    }
                                });

                            }
                        }
                    },
                    columns: [{
                            data: 'count',
                            name: 'count'
                        },
                        {
                            data: 'id',
                            name: 'id',
                            visible: false
                        },
                        {
                            data: 'leave_type_id',
                            name: 'leave_type_id',
                            visible: false
                        },
                        {
                            data: 'employee_name',
                            name: 'employee_name'
                        },

                        {
                            data: 'leave_type',
                            name: 'leave_type'
                        },
                        {
                            data: 'leave_status',
                            name: 'leave_status',
                            render: function(data, type, row) {
                                if (data === 'paid') {
                                    return `<span class="text-white badge badge-pill fw-bold badge bg-success">Paid</span>`;
                                } else if (data === 'unpaid') {
                                    return `<span class="text-white badge badge-pill fw-bold badge bg-danger">Unpaid</span>`;
                                } else if (data === 'reject') {
                                    return `<span class="text-white badge badge-pill fw-bold badge bg-danger">Rejected</span>`;
                                } else if (data === 'processing') {
                                    return `<span class="text-white badge badge-pill fw-bold badge bg-warning">Processing</span>`;
                                }
                                return data; // Default case if the status is something unexpected
                            }
                        },

                        {
                            data: 'start_date',
                            name: 'start_date',
                            render: function(data) {
                                return new Date(data).toLocaleDateString('en-GB', {
                                    day: '2-digit',
                                    month: 'short',
                                    year: 'numeric'
                                });
                            }
                        },
                        {
                            data: 'end_date',
                            name: 'end_date',
                            render: function(data) {
                                return new Date(data).toLocaleDateString('en-GB', {
                                    day: '2-digit',
                                    month: 'short',
                                    year: 'numeric'
                                });
                            }
                        },

                        {
                            data: 'reason',
                            name: 'reason'
                        },

                        {
                            data: null,
                            name: 'status',
                            render: function(data, type, row) {

                                let rejectUrl = `{{ route('leave_reject', ':id') }}`.replace(':id', row
                                    .id); // Dynamic URL for rejection

                                if (row.status === 'pending') {
                                    return `
                <div class="d-flex p-10 ">
                     <button data-id="${row.id}" id="allowLeave"  class="leave_btn text-white badge badge-pill fw-bold badge bg-success mr-2">Approve</button>
                    <form action="${rejectUrl}" method="POST">
                        @csrf
                        @method('PUT')
                        <input type="hidden" name="user_id" value="${row.user.id}">
                        <input type="hidden" name="leave_type_id" value="${row.leave_type_id}">
                        <button  type="submit" class="leave_btn text-white badge badge-pill fw-bold badge bg-danger ">Reject</button>
                    </form>
                </div>
            `;
                                } else if (row.status === 'approve') {
                                    return `<span class="text-white badge badge-pill fw-bold badge bg-success">Approved</span>`;
                                } else if (row.status === 'reject') {
                                    return `<span class="text-white badge badge-pill fw-bold badge bg-danger">Rejected</span>`;
                                }
                            }
                        }
                    ]
                });



                $('body').on('click', '#allowLeave', function() {
                    var id = $(this).data('id');
                    $.ajax({
                        type: "GET",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('get_leave', ['id' => ':id']) }}".replace(':id', id),
                        success: function(response) {
                            if (response.status === 404) {
                                $('#allowLeaveModal').modal('hide');
                                toastr.error('User not found.');
                            } else {
                                $('#allowLeaveModal').modal('show');
                                var leave = response;
                                $('#leave_id').val(leave.id); // Set email
                                $('#user_id').val(leave.user_id);
                                $('#update_leave_type_id').val(leave.leave_type_id);


                                // Other fields...
                            }
                        },
                        error: function(xhr) {
                            toastr.error('An error occurred while fetching the User.');
                        }
                    });
                });



                $('#allowLeaveForm').on('submit', function(e) {
                    e.preventDefault();

                    var id = $('#leave_id').val(); 

                    let $submitButton = $('#allowLeaveForm button[type="submit"]');
                    $submitButton.prop('disabled', true);

                    $.ajax({
                        type: 'PUT',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('leave_approve', ['id' => ':id']) }}".replace(':id', id),
                        data: $(this).serialize(),
                        success: function(response) {
                            console.log("AJAX Success:", response); 

                            if (response.success) {
                                $('#allowLeaveModal').modal('hide');
                                $('#leave_table').DataTable().ajax.reload();
                                toastr.success(response.message); 
                                $('#allowLeaveForm')[0].reset();
                            } else {
                                handleErrors(response.errors);
                            }
                        },
                        error: function(xhr) {
                            if (xhr.status === 422 && xhr.responseJSON.errors) {
                                handleErrors(xhr.responseJSON.errors);
                            } else if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorsQueue.push(xhr.responseJSON.message);
                                displayErrors(); 
                            } else {
                                errorsQueue.push('An error occurred. Please try again.');
                                displayErrors();
                            }
                        },
                        complete: function() {
                            $submitButton.prop('disabled',
                                false);
                        }
                    });
                });

                $('#add_leave').on('click', function() {
                    $('#createLeave').modal('show');
                });
                $('#addLeaveForm').on('submit', function(e) {
                    e.preventDefault();
                    var employeeId = $('#user_leave_id').val();
                    var leave_type = $('#leave_type_id').val();
                    if (!employeeId) {
                        toastr.error('Please select an employee.');
                        $submitButton.prop('disabled', false); // Re-enable the submit button
                        return;
                    }
                    if (!leave_type) {
                        toastr.error('Please select an Leavy Type.');
                        $submitButton.prop('disabled', false); // Re-enable the submit button
                        return;
                    }
                    let $submitButton = $('#addLeaveForm button[type="submit"]');
                    $submitButton.prop('disabled', true);

                    $.ajax({
                        type: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('add_admin_leave_form') }}",
                        data: $(this).serialize(),
                        success: function(response) {
                            if (response.success) {
                                $('#createLeave').modal('hide');
                                $('#leave_table').DataTable().ajax.reload();
                                $('#addLeaveForm')[0].reset();
                                toastr.success(response.message);
                            } else {
                                // Display the first validation error only
                                let firstError = null;

                                if (response.errors) {
                                    $.each(response.errors, function(key, errors) {
                                        // Take the first error message of the first field that has an error
                                        firstError = errors[0];
                                        return false; // Break out of loop after the first error
                                    });
                                }

                                if (firstError) {
                                    toastr.error(firstError);
                                } else {
                                    toastr.error(response.message || 'An error occurred.');
                                }
                            }
                        },
                        error: function(xhr) {
                            console.log("AJAX Error:", xhr);
                            toastr.error(
                                'The End Date must be After Start Date.'); // General error message
                        },
                        complete: function() {
                            $submitButton.prop('disabled', false);
                        }
                    });
                });


                $('#user_leave_id').on('change', function() {
                    var id = $(this).val(); // Get the selected employee ID

                    // Make AJAX request to fetch total and remaining leaves
                    $.ajax({
                        url: "{{ route('get_total_leaves', ['id' => ':id']) }}".replace(':id', id),
                        method: 'GET',
                        success: function(response) {
                            if (response.success) {
                                // Update the span with the fetched leaves data
                                $('#remainingLeaves').text(response.remaining_leaves);
                                $('#totalLeaves').text(response.total_allocated_leaves);
                            } else {
                                toastr.error(response.message);
                            }
                        },
                        error: function(xhr, status, error) {
                            toastr.error('An error occurred while fetching the leaves data.');
                        }
                    });
                });

            });
        </script>
    @endpush
@endsection
