<?php $__env->startSection('content'); ?>
    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    User List
                </h3>
                <nav class="col-md-6 text-right" aria-label="breadcrumb">
                    <button data-bs-toggle="modal" id="add_user" class="btn btn-sm btn-outline-primary">
                        <i class="fa fa-plus-circle mr-sm-2"></i>Create User</button>
                </nav>
                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a
                                style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">User List
                        </li>
                    </ol>
                </nav>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table id="user_table" class="data_table table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>id</th>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Permissions</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>




    <div class="modal fade" id="createUser" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Add User</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="addUserForm">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" class="user_id">
                        <label for="">Employee</label>
                        <select type="text" class="form-control" id="employee_id" name="employee_id" required>
                            <option selected disabled>Select Employee</option>
                            <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($employee['id']); ?>"><?php echo e($employee['name']); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>

                        <label class="mt-4" for="email">Email</label>
                        <input type="email" class="form-control" id="email" name="email" placeholder="Enter Email"
                            readonly>

                        <label class="mt-4" for="permissions">Permissions</label>
                        <select name="permissions[]" id="permissions" class="form-control select2" multiple>
                            <?php if(session('permissions')): ?>
                                <?php
                                    $permissions = session('permissions');
                                ?>

                                <?php if(in_array('all', $permissions)): ?>
                                    <option value="leave_request">Leave Request</option>
                                    <option value="employee">Employee Management</option>
                                    <option value="finance">Finance</option>
                                    <option value="settings">Settings</option>
                                    <option value="users">Users</option>
                                <?php else: ?>
                                    <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($permission); ?>"><?php echo e(ucfirst($permission)); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            <?php else: ?>
                                <option value="">No permissions available</option>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Add</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>



    <script>
        $('#employee_id').on('change', function() {
            var employeeId = $(this).val(); // Get the selected employee ID

            // Make an AJAX request to get user details for the selected employee
            $.ajax({
                url: "<?php echo e(route('get_user', ':id')); ?>".replace(':id',
                    employeeId), // Using route helper with dynamic ID
                type: 'GET',
                success: function(response) {
                    // Check if the response contains the employee's email
                    if (response.email) {
                        // Populate the email field with the employee's email
                        $('#email').val(response.email);
                        $('.user_id').val(response.id);
                    } else {
                        // Clear the email field if no email is found
                        $('#email').val('');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('An error occurred:', error);
                    // Optionally show an alert or message to the user
                    $('#email').val(''); // Clear the email field on error
                }
            });
        });
    </script>
    <?php $__env->startPush('js'); ?>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
        <script>
            $(".select2").select2({
                width: '100%',
            });
        </script>
        <script>
            $(document).ready(function() {
             
                var session_data = <?php echo json_encode(session()->all(), 15, 512) ?>;
                
                $('#user_table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: '<?php echo e(env('API_BASE_URL')); ?>/users/permissions/index',
                        beforeSend: function(xhr) {
                            xhr.setRequestHeader('Authorization', session_data.bearer_token);
                        },
                        complete: function(response) {
                            // After the API call is complete, restore the session data
                            if (response.status === 200) {
                                $.ajax({
                                    type: 'GET',
                                    url: '<?php echo e(route('restore_session_data')); ?>',
                                    data: {
                                        bearer_token: session_data.bearer_token,
                                        role: session_data.role,
                                        permissions: session_data.permissions,
                                        org_id: session_data.org_id,
                                        id: session_data.id,
                                        logo: session_data.logo,
                                        currency: session_data.currency,
                                        employee_id: session_data.employee_id,
                                        user_name: session_data.user_name,
                                        designation: session_data.designation,
                                    },
                                    success: function(data) {
                                        if (data.success) {
                                            console.log("Session restored successfully");
                                        } else {
                                            console.error("Failed to restore session");
                                        }
                                        console.log(data);
                                    },
                                    error: function(xhr) {
                                        console.error("Error restoring session:", xhr);
                                    }
                                });

                            }
                        }
                    },
                    columns: [{
                            data: 'count',
                            name: 'count'
                        },
                        {
                            data: 'id',
                            name: 'id',
                            visible: false
                        },
                        {
                            data: 'name',
                            name: 'name'
                        },
                        {
                            data: 'email',
                            name: 'email'
                        },

                        {
                            data: 'permissions',
                            name: 'permissions'
                        },
                        {
                            data: 'status',
                            name: 'status'
                        },
                        {
                            data: null,
                            name: 'action',
                            render: function(data, type, row) {
                                return `
                        <div class="dropdown">
                            <a style="font-size: 19px; color:black; text-decoration: none;" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                ⋮
                            </a>

                            <div class="dropdown-menu"  aria-labelledby="dropdownMenuLink" x-placement="bottom-start" style="position: absolute; transform: translate3d(0px, 21px, 0px); top: 0px; left: 0px; will-change: transform;">
                             
                                <button data-id="${row.id}" id="updateStatusButton" class="dropdown-item text-danger">
                                    <i class="fa fa-arrow-right mr-2"></i> Change Status
                                </button>
                            </div>
                        </div>
                    `;
                            }
                        }
                    ]
                });

                
                $('#add_user').on('click', function() {
                    $('#createUser').modal('show');
                });
                $('#addUserForm').on('submit', function(e) {
                    e.preventDefault();

                    var id = $('.user_id').val(); // Get the allowance ID

                    // Disable the submit button to prevent multiple submissions
                    let $submitButton = $('#addUserForm button[type="submit"]');
                    $submitButton.prop('disabled', true);

                    // Validate form inputs
                    var employeeId = $('#employee_id').val();
                    var permissions = $('#permissions').val();

                    if (!employeeId) {
                        toastr.error('Please select an employee.');
                        $submitButton.prop('disabled', false); // Re-enable the submit button
                        return;
                    }

                    if (!permissions || permissions.length === 0) {
                        toastr.error('Please select at least one permission.');
                        $submitButton.prop('disabled', false); // Re-enable the submit button
                        return;
                    }

                    $.ajax({
                        type: 'PUT',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('update_user_form', ['id' => ':id'])); ?>".replace(':id', id),
                        data: $(this).serialize(),
                        success: function(response) {
                            console.log("AJAX Success:", response); // Log response for debugging

                            if (response.success) {
                                $('#createUser').modal('hide');
                                $('#user_table').DataTable().ajax.reload(); // Reload DataTable
                                toastr.success(response.message); // Success notification
                                $('#addUserForm')[0].reset();
                                $('#permissions').val(null).trigger('change');
                            } else {
                                handleErrors(response.errors); // Handle validation or other errors
                            }
                        },
                        error: function(xhr) {
                            if (xhr.status === 422 && xhr.responseJSON.errors) {
                                // Validation error from the backend
                                handleErrors(xhr.responseJSON.errors);
                            } else if (xhr.responseJSON && xhr.responseJSON.message) {
                                // General error message
                                errorsQueue.push(xhr.responseJSON.message);
                                displayErrors(); // Display the general error message
                            } else {
                                errorsQueue.push('An error occurred. Please try again.');
                                displayErrors(); // Display fallback error
                            }
                        },
                        complete: function() {
                            $submitButton.prop('disabled',
                            false); // Re-enable the submit button after the request completes
                        }
                    });
                });

                $(document).on('click', '#updateStatusButton', function() {
                    var id = $(this).data('id'); // Get the ID from the clicked button
                    $.ajax({
                        type: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr(
                                'content') // Laravel CSRF token
                        },
                        url: "<?php echo e(route('update_user_status')); ?>", // Your route for updating the status
                        data: {
                            id: id // Pass the ID as data in the request
                        },
                        success: function(response) {
                            if (response.success) {
                                toastr.success(response.message); // Show success message
                                // Optionally reload table or update UI
                                $('#user_table').DataTable().ajax.reload();
                            } else {
                                toastr.error(response.message); // Show error message
                            }
                        },
                        error: function(xhr) {
                            let response = xhr.responseJSON || {};
                            toastr.error(response.message || 'An error occurred.');
                        }
                    });
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/microsolscom/public_html/devioo-hrm/resources/views/admin/user/user.blade.php ENDPATH**/ ?>