<?php $__env->startSection('content'); ?>
    <style>
        .expense_btn {
            border: none;
            cursor: pointer;
        }
    </style>
    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    Expense Request List
                </h3>

                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Expense Request List</li>
                    </ol>
                </nav>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table id="income_table" class="data_table table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>id</th>
                                            <th>Employee</th>
                                            <th>Amount</th>
                                            <th>Date</th>
                                            <th>Description</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('js'); ?>
        <script>
            $(document).ready(function() {
                var session_data = <?php echo json_encode(session()->all(), 15, 512) ?>;
                

                $('#income_table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: `<?php echo e(env('API_BASE_URL')); ?>/incomes/search/index?type=employee_expense`,
                        beforeSend: function(xhr) {
                            xhr.setRequestHeader('Authorization', session_data.bearer_token);
                        },
                        complete: function(response) {
                            if (response.status === 200) {
                                $.ajax({
                                    type: 'GET',
                                    url: '<?php echo e(route('restore_session_data')); ?>',
                                    data: {
                                        bearer_token: session_data.bearer_token,
                                        role: session_data.role,
                                        permissions: session_data.permissions,
                                        org_id: session_data.org_id,
                                        id: session_data.id,
                                        currency: session_data.currency,
                                        logo: session_data.logo,
                                        employee_id: session_data.employee_id,
                                        user_name: session_data.user_name,
                                        designation: session_data.designation,
                                    },
                                    success: function(data) {
                                        if (data.success) {
                                            console.log("Session restored successfully");
                                        } else {
                                            console.error("Failed to restore session");
                                        }
                                    },
                                    error: function(xhr) {
                                        console.error("Error restoring session:", xhr);
                                    }
                                });
                            }
                        }
                    },
                    columns: [
                        {
                            data: 'count',
                            name: 'count'
                        },
                        {
                            data: 'id',
                            name: 'id',
                            visible: false
                        },
                        {
                            data: 'employee_name',
                            name: 'employee_name'
                        },
                        {
                            data: 'amount',
                            name: 'amount'
                        },
                        {
                            data: 'date',
                            name: 'date',
                            render: function(data) {
                                return new Date(data).toLocaleDateString('en-GB', {
                                    day: '2-digit',
                                    month: 'short',
                                    year: 'numeric'
                                });
                            }
                        },
                        {
                            data: 'description',
                            name: 'description'
                        },
                        {
                            data: null,
                            name: 'status',
                            render: function(data, type, row) {
                                let approveUrl = `<?php echo e(route('expense_approve', ':id')); ?>`.replace(':id', row.id);
                                let rejectUrl = `<?php echo e(route('expense_reject', ':id')); ?>`.replace(':id', row.id);

                                if (row.status === 'pending') {
                                    return `
                                        <div class="d-flex">
                                            <form action="${approveUrl}" method="POST" style="margin-right: 5px;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>
                                                <input type="hidden" name="user_id" value="${row.id}">
                                                <button type="submit" class="expense_btn text-white badge badge-pill fw-bold badge bg-success">Approve</button>
                                            </form>
                                            <form action="${rejectUrl}" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>
                                                <input type="hidden" name="user_id" value="${row.id}">
                                                <button type="submit" class="expense_btn text-white badge badge-pill fw-bold badge bg-danger">Reject</button>
                                            </form>
                                        </div>
                                    `;
                                } else if (row.status === 'approve') {
                                    return `<span class="text-white badge badge-pill fw-bold badge bg-success">Approved</span>`;
                                } else if (row.status === 'reject') {
                                    return `<span class="text-white badge badge-pill fw-bold badge bg-danger">Rejected</span>`;
                                }
                            }
                        }
                    ]
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/microsols/public_html/hrm.microsols.com/resources/views/admin/expense_request/admin_expense_request.blade.php ENDPATH**/ ?>