<?php $__env->startSection('content'); ?>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            // Your existing print script...
        });
    </script>

    <div class="content-wrapper PrintBody">
        <div class="col-12">
            <img src="<?php echo e(asset('assets/images/hexon-logo.png')); ?>" class="img d-none" alt="Logo" style="width:100%; max-width:200px">
        </div>
        <div class="row page-header">
            <h3 class="col-md-6 page-title title">Finance Report</h3>
            <nav class="col-md-6 text-right" aria-label="breadcrumb">
                <button type="button" id="filter" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#Filter-modal"><i class="fa fa-filter mr-1"></i> Apply Filter</button>
            </nav>
            <nav class="col-12 title" aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a></li>
                    <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Finance Report</li>
                </ol>
            </nav>
        </div>

        <div class="row">
            <?php if($totals['type'] === 'income' || $totals['type'] === 'both'): ?>
                <div class="col-md-4 grid-margin">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="card-title mb-0 font-weight-bold">Total Income</h4>
                            <div class="d-flex justify-content-between align-items-center">
                                <div class="d-inline-block pt-3">
                                    <h2 class="mb-0"><?php echo e(session('currency')); ?> <?php echo e(number_format($totals['total_income'] ?? 0)); ?></h2>
                                </div>
                                <div class="d-inline-block">
                                    <i class="fas fa-chart-pie text-success" style="font-size: 50px" title="Total Income"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        
            <?php if($totals['type'] === 'expense' || $totals['type'] === 'both'): ?>
                <div class="col-md-4 grid-margin">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="card-title mb-0 font-weight-bold">Total Expense</h4>
                            <div class="d-flex justify-content-between align-items-center">
                                <div class="d-inline-block pt-3">
                                    <h2 class="mb-0"><?php echo e(session('currency')); ?> <?php echo e(number_format($totals['total_expense'] ?? 0)); ?></h2>
                                </div>
                                <div class="d-inline-block">
                                    <i class="fas fa-chart-line text-danger" style="font-size: 50px" title="Total Expense"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        
            <?php if($totals['type'] === 'both'): ?>
                <div class="col-md-4 grid-margin">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="card-title mb-0 font-weight-bold">Total Revenue</h4>
                            <div class="d-flex justify-content-between align-items-center">
                                <div class="d-inline-block pt-3">
                                    <h2 class="mb-0"><?php echo e(session('currency')); ?> <?php echo e(number_format($totals['total_revenue'] ?? 0)); ?></h2>
                                </div>
                                <div class="d-inline-block">
                                    <i class="fas fa-money-bill-wave text-success" style="font-size: 50px" title="Total Revenue"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        

        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-12">
                        <div class="row py-3 px-3">
                            <div class="table-responsive" id="table">
                                <table id="order-listing" class="table">
                                    <thead>
                                        <tr>
                                            <th class="text-center">#</th>
                                            <th class="text-center">Date</th>
                                            <th class="text-center">Description</th>
                                            <th class="text-center">Amount (<?php echo e(session('currency')); ?>)</th>
                                            <th class="text-center">Type</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $mergedData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td class="text-center"><?php echo e($loop->iteration); ?></td>
                                                <td class="text-center"><?php echo e(\Carbon\Carbon::parse($item['date'])->format('Y-m-d')); ?></td>
                                                <td class="text-center"><?php echo e($item['description']); ?></td>
                                                <td class="text-center"> <?php echo e(number_format($item['amount'])); ?></td>
                                                <td class="text-center">
                                                    <span class="badge <?php echo e($item['type'] === 'income' ? 'badge-success' : 'badge-danger'); ?>">
                                                        <?php echo e(ucfirst($item['type'])); ?>

                                                    </span>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="Filter-modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2" aria-hidden="true">
        <div class="modal-dialog modal-md" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Filter Data</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="<?php echo e(route('finance_report')); ?>" method="GET">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        <div class="form-group">
                            <label for="timeframe" class="font-weight-bold">Select Timeframe</label>
                            <div class="btn-group btn-group-toggle w-100" data-toggle="buttons">
                                <label class="btn btn-outline-secondary active flex-fill">
                                    <input type="radio" name="timeframe" id="month-toggle" value="month" checked> Month
                                </label>
                                <label class="btn btn-outline-secondary flex-fill">
                                    <input type="radio" name="timeframe" id="year-toggle" value="year"> Year
                                </label>
                                <label class="btn btn-outline-secondary flex-fill">
                                    <input type="radio" name="timeframe" id="custom-toggle" value="custom"> Custom
                                </label>
                            </div>
                        </div>
                        <div class="form-group">
                            <input type="month" id="month" class="form-control datepicker" name="month" required>
                            <label for="year" class="font-weight-bold" style="display: none;">Year</label>
                            <select id="year" class="form-control" name="year" style="display: none;">
                                <option value="" disabled selected>Select Year</option>
                                <?php for($i = date('Y') - 5; $i <= date('Y') + 5; $i++): ?>
                                    <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                                <?php endfor; ?>
                            </select>
                        </div>
                        <div id="custom-date-range" style="display: none;">
                            <div class="form-group">
                                <label for="start-date" class="font-weight-bold">Start Date</label>
                                <input type="date" id="start-date" class="form-control" name="start_date">
                            </div>
                            <div class="form-group">
                                <label for="end-date" class="font-weight-bold">End Date</label>
                                <input type="date" id="end-date" class="form-control" name="end_date">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="type" class="font-weight-bold">Select Type</label>
                            <div class="btn-group btn-group-toggle w-100" data-toggle="buttons">
                                <label class="btn btn-outline-secondary flex-fill">
                                    <input type="radio" name="type" id="income-toggle" value="income"> Income
                                </label>
                                <label class="btn btn-outline-secondary flex-fill">
                                    <input type="radio" name="type" id="expense-toggle" value="expense"> Expense
                                </label>
                                <label class="btn btn-outline-secondary active flex-fill">
                                    <input type="radio" name="type" id="both-toggle" value="both" checked> Both
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Apply Filter</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    
    
    
    
    


<script>
 $(document).ready(function() {
    // Show/hide elements based on the selected timeframe and toggle the "required" attribute
    $('input[name="timeframe"]').on('change', function() {
        if ($('#month-toggle').is(':checked')) {
            $('#month').show().attr('required', true);
            $('#year').hide().removeAttr('required');
            $('#custom-date-range').hide();
            $('#start-date, #end-date').removeAttr('required');
        } else if ($('#year-toggle').is(':checked')) {
            $('#month').hide().removeAttr('required');
            $('#year').show().attr('required', true);
            $('#custom-date-range').hide();
            $('#start-date, #end-date').removeAttr('required');
        } else if ($('#custom-toggle').is(':checked')) {
            $('#month').hide().removeAttr('required');
            $('#year').hide().removeAttr('required');
            $('#custom-date-range').show();
            $('#start-date, #end-date').attr('required', true); // Make start/end date required
        }
    });

    // Trigger change event on page load to set the correct fields' visibility and "required" attribute
    $('input[name="timeframe"]:checked').trigger('change');
});

</script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/microsols/public_html/hrm.microsols.com/resources/views/admin/reports/finance_report.blade.php ENDPATH**/ ?>