<?php $__env->startSection('content'); ?>
    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    Income List
                </h3>
                <nav class="col-md-6 text-right" aria-label="breadcrumb" style="
                            display: flex;
                            justify-content: flex-end;
                            align-items: baseline;
                            ">
                                    
                                        
                                    <div class="col-md-4"><select id="incomeTypeFilter" class="form-control">
                                            <option value="all">All Types</option>
                                            <option value="income">Income</option>
                                            <option value="kafala">Kafala</option>
                                        </select></div>
                                        <div><button data-bs-toggle="modal" id="add_income" class="btn btn-sm btn-outline-primary">
                                        <i class="fa fa-plus-circle mr-sm-2"></i>Create Income</button></div>
                </nav>
               
                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a
                                style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Income List
                        </li>
                    </ol>
                </nav>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table id="income_table" class="data_table table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>id</th>
                                            <th>Income Type</th>
                                            <th>Amount</th>
                                            <th>Date</th>
                                            <th>Description</th>


                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>




    <div class="modal fade" id="createIncome" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Add Income</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="addIncomeForm" method="POST">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        <?php echo csrf_field(); ?>
                        <label>Type</label>
                        <select name="income_expence_type" class="form-control mb-3" id="incomeType">
                            <option value="income">Income</option>
                            <option value="kafala">Kafala</option>
                        </select>

                        <label>Employee</label>
                        <select name="employee_id" class="form-control mb-3"  id="employeeField" style="display: none;">
                            <option value="">Select Employee</option>
                            <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($employee['id']); ?>"><?php echo e($employee['name']); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>

                        <label>Amount</label>
                        <input class="form-control" type="number" id="amount" name="amount" placeholder="Enter amount"
                            required></input>

                        <label class="mt-4">Date</label>
                        <input class="form-control" type="date" id="date" name="date" placeholder="Enter date"
                            required></input>


                        <label class="mt-4">Description</label>
                        <textarea class="form-control" type="text" id="description" name="description" rows="5"
                            placeholder="Enter description" required></textarea>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Add</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="updateIncome" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Update Income</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="updateIncomeForm">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="income_id" id="income_id">
                        <label>Amount</label>
                        <input class="form-control" type="number" id="update_amount" name="amount"
                            placeholder="Enter amount" required></input>

                        <label class="mt-4">Date</label>
                        <input class="form-control" type="date" id="update_date" name="date"
                            placeholder="Enter date" required></input>

                        <label class="mt-4">Description</label>
                        <textarea class="form-control" type="text" id="update_description" name="description" rows="5"
                            placeholder="Enter description" required></textarea>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Update</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <?php $__env->startPush('js'); ?>
        <script>
            $(document).ready(function() {

                 function toggleEmployeeField() {
                const incomeType = $('#incomeType').val(); // Get selected value
                    const employeeField = $('#employeeField'); // Get employee field element

                    if (incomeType === 'kafala') {
                        employeeField.show(); // Show the field
                    } else {
                        employeeField.hide(); // Hide the field
                    }
                }

                // Attach the change event listener to the select field
                $('#incomeType').on('change', toggleEmployeeField);

                // Trigger the function on page load in case "kafala" is pre-selected
                toggleEmployeeField();

                var session_data = <?php echo json_encode(session()->all(), 15, 512) ?>;

                let incomeTable = $('#income_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '<?php echo e(env('API_BASE_URL')); ?>/incomes/search/index?type=income&income_expence_type=kafala',
                    data: function(d) {
                        d.income_expence_type = $('#incomeTypeFilter').val();
                    },
                    beforeSend: function(xhr) {
                        xhr.setRequestHeader('Authorization', session_data.bearer_token);
                    },
                    complete: function(response) {
                        if (response.status === 200) {
                            $.ajax({
                                type: 'GET',
                                url: '<?php echo e(route('restore_session_data')); ?>',
                                data: {
                                    bearer_token: session_data.bearer_token,
                                    role: session_data.role,
                                    permissions: session_data.permissions,
                                    org_id: session_data.org_id,
                                    id: session_data.id,
                                    logo: session_data.logo,
                                    employee_id: session_data.employee_id,
                                    currency: session_data.currency,
                                    user_name: session_data.user_name,
                                    designation: session_data.designation,
                                },
                                success: function(data) {
                                    if (data.success) {
                                        console.log("Session restored successfully");
                                    } else {
                                        console.error("Failed to restore session");
                                    }
                                    console.log(data);
                                },
                                error: function(xhr) {
                                    console.error("Error restoring session:", xhr);
                                }
                            });
                        }
                    }
                },
                columns: [
                    { data: 'count', name: 'count' },
                    { data: 'id', name: 'id', visible: false },
                    { data: 'income_expence_type', name: 'income_expence_type' },
                    {
                            data: 'amount',
                            name: 'amount',
                            render: function(data) {
                                return `${data} ${session_data.currency}`;
                            }
                        },

                    { data: 'date', name: 'date', render: function(data) {
                        return new Date(data).toLocaleDateString('en-GB', {
                            day: '2-digit',
                            month: 'short',
                            year: 'numeric'
                        });
                    }},
                    { data: 'description', name: 'description' },
                    { data: null, name: 'action', render: function(data, type, row) {
                        return `
                        <div class="dropdown">
                            <a style="font-size: 19px; color:black; text-decoration: none;" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                ⋮
                            </a>
                            <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                                <button data-id="${row.id}" id="editincomebtn" class="dropdown-item text-primary">
                                    <i class="fa fa-pen mr-2"></i> Edit
                                </button>
                                <button data-id="${row.id}" id="delete_income" class="dropdown-item text-danger">
                                    <i class="far fa-trash-alt mr-2"></i> Delete
                                </button>
                            </div>
                        </div>`;
                    }}
                ],
                dom: '<"top"lfrB>rt<"bottom"ip><"clear">', // Adjusted dom order
                buttons: [
                    {
                        extend: 'csvHtml5',
                        text: '<i class="fas fa-download"></i>',
                        title: 'Incomes',
                        exportOptions: {
                            columns: [0, 1, 2, 3]
                        }
                    }
                ]
            });

            $('#incomeTypeFilter').change(function() {
                incomeTable.ajax.reload();
            });

                

                $('#add_income').on('click', function() {
                    $('#createIncome').modal('show');
                });
                $('#addIncomeForm').on('submit', function(e) {
                    e.preventDefault();

                    let $submitButton = $('#addIncomeForm button[type="submit"]');
                    $submitButton.prop('disabled', true);

                    $.ajax({
                        type: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('add_income_form')); ?>",
                        data: $(this).serialize(),
                        success: function(response) {
                            console.log(response);
                            if (response.success) {
                                $('#createIncome').modal('hide');
                                $('#income_table').DataTable().ajax.reload();
                                $('#addIncomeForm')[0].reset();
                                toastr.success(response.message);
                            } else {
                                let errorMessage = response.message;
                                if (response.errors) {
                                    errorMessage += '<br><br>Errors:<ul>';
                                    $.each(response.errors, function(key, errors) {
                                        $.each(errors, function(index, error) {
                                            errorMessage += '<li>' + error +
                                                '</li>';
                                        });
                                    });
                                    errorMessage += '</ul>';
                                }
                                toastr.error(errorMessage);
                            }
                        },
                        error: function(xhr) {
                            console.log("AJAX Error:", xhr);
                            toastr.error('Invalid Details '); // General error message
                        },
                        complete: function() {
                            $submitButton.prop('disabled', false);
                        }
                    });
                });

                $('body').on('click', '#delete_income', function() {
                    var id = $(this).data('id');

                    $.ajax({
                        type: "DELETE",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('delete_income', ['id' => ':id'])); ?>"
                            .replace(':id', id),
                        success: function(response) {
                            $('#income_table').DataTable().ajax.reload();
                            // Show success Toastr message
                            toastr.success('Income deleted successfully');
                        },
                        error: function(xhr) {
                            // Display error Toastr message
                            let errorMessage = 'An error occurred while deleting the Income.';
                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorMessage = xhr.responseJSON.message;
                            }
                            toastr.error(errorMessage);
                        }
                    });
                });

                $('body').on('click', '#editincomebtn', function() {
                    var id = $(this).data('id');



                    $.ajax({
                        type: "GET",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('get_expense', ['id' => ':id'])); ?>"
                            .replace(':id', id),
                        success: function(response) {

                            if (response.status === 404) {
                                $('#updateIncome').modal('hide');
                                toastr.error('Income not found.');
                            } else {
                                $('#updateIncome').modal('show');
                                var income =
                                    response;
                                console.log(income); // response is already the department data
                                $('#income_id').val(income.id);
                                // $('#update_employee_id').val(income.empoyee_id);
                                $('#update_amount').val(income.amount);
                                $('#update_date').val(income.date);

                                $('#update_description').val(income.description);
                            }
                        },
                        error: function(xhr) {

                            toastr.error('An error occurred while fetching the Income.');
                        }
                    });
                });

                $('#updateIncomeForm').on('submit', function(e) {
                    e.preventDefault();

                    var id = $('#income_id').val(); // Use the correct ID

                    // Disable the submit button to prevent multiple submissions
                    let $submitButton = $('#updateIncomeForm button[type="submit"]');
                    $submitButton.prop('disabled', true);

                    $.ajax({
                        type: 'PUT',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('update_income_form', ['id' => ':id'])); ?>".replace(':id',
                            id),
                        data: $(this).serialize(),
                        success: function(response) {
                            console.log("AJAX Success:", response); // Log response for debugging

                            if (response.success) {
                                $('#updateIncome').modal('hide');
                                $('#income_table').DataTable().ajax
                                    .reload(); // Reload DataTable
                                toastr.success(response.message);
                                $('#updateIncomeForm')[0].reset();
                            } else {
                                // Handle validation or other errors
                                let errorMessage = response.message || 'An error occurred.';
                                toastr.error(errorMessage); // Display error
                            }
                        },
                        error: function(xhr) {
                            console.log("AJAX Error:", xhr); // Log the error for debugging
                            let errorMessage = 'An unexpected error occurred.';
                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorMessage = xhr.responseJSON.message;
                            }
                            toastr.error(errorMessage); // Display error
                        },
                        complete: function() {
                            // Re-enable the submit button after the request completes
                            $submitButton.prop('disabled', false);
                        }
                    });
                });

            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/microsolscom/public_html/devioo-hrm/resources/views/admin/settings/income.blade.php ENDPATH**/ ?>