<?php $__env->startSection('content'); ?>
    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    User List
                </h3>
                <nav class="col-md-6 text-right" aria-label="breadcrumb">
                    <button data-bs-toggle="modal" id="add_user" class="btn btn-sm btn-outline-primary">
                        <i class="fa fa-plus-circle mr-sm-2"></i>Create User</button>
                </nav>
                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a
                                style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">User List
                        </li>
                    </ol>
                </nav>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table id="user_table" class="data_table table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Role</th>
                                            <th>Status</th>
                                      
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>




    <div class="modal fade" id="createUser" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Add User</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="addUserForm" method="POST">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        <?php echo csrf_field(); ?>
                        <label for="name">Name</label>
                        <input type="text" class="form-control" id="name" name="name" placeholder="Enter Name"
                            required>

                        <label class="mt-4" for="email">Email</label>
                        <input type="email" class="form-control" id="email" name="email" placeholder="Enter Email"
                            required>

                        <label class="mt-4" for="password">Password</label>
                        <input type="password" class="form-control" id="password" name="password"
                            placeholder="Enter Password" required>

                        <label class="mt-4" for="password_confirmation">Confirm Password</label>
                        <input type="password" class="form-control" id="password_confirmation" name="password_confirmation"
                            placeholder="Confirm Password" required>
                        
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Add</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>

            </div>
        </div>
    </div>

    <div class="modal fade" id="updateUser" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Update User</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="updateUserForm">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="user_id" id="user_id">
                        <label for="name">Name</label>
                        <input type="text" class="form-control" id="update_name" name="name"
                            placeholder="Enter Name" required>

                        <label class="mt-4" for="email">Email</label>
                        <input type="email" class="form-control" id="update_email" name="email"
                            placeholder="Enter Email" required>

                        <label class="mt-4" for="password">Password</label>
                        <input type="password" class="form-control" id="password" name="password"
                            placeholder="Enter Password" >

                        <label class="mt-4" for="password_confirmation">Confirm Password</label>
                        <input type="password" class="form-control" id="password_confirmation"
                            name="password_confirmation" placeholder="Confirm Password" >
                        
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Update</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <?php $__env->startPush('js'); ?>
        <script>
            $(document).ready(function() {
                $('#user_table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: '<?php echo e(route('admin_list')); ?>',
                    columns: [{
                            data: 'id',
                            name: 'id'
                        },
                        {
                            data: 'name',
                            name: 'name'
                        },
                        {
                            data: 'email',
                            name: 'email'
                        },
                        {
                            data: 'role',
                            name: 'role',
                            render: function(data, type, row) {
                                if (data === 'admin_normal') {
                                    return `<span class="text-center"> --</span>`;
                                }
                                return data; // Default case if the status is something unexpected
                            }
                        },
                        {
                            data: 'status',
                            name: 'status'
                        },
                        {
                            data: null,
                            name: 'action',
                            render: function(data, type, row) {
                                return `
                        <div class="dropdown">
                            <a style="font-size: 19px; color:black; text-decoration: none;" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                ⋮
                            </a>

                            <div class="dropdown-menu"  aria-labelledby="dropdownMenuLink" x-placement="bottom-start" style="position: absolute; transform: translate3d(0px, 21px, 0px); top: 0px; left: 0px; will-change: transform;">
                                <button data-id="${row.id}" id="editallowtbtn"  class="dropdown-item text-primary">
                                    <i class="fa fa-pen mr-2"></i> Edit
                                </button>
                                <button data-id="${row.id}" id="updateStatusButton" class="dropdown-item text-danger">
                                    <i class="fa fa-arrow-right mr-2"></i> Change Status
                                </button>
                            </div>
                        </div>
                    `;
                            }
                        }
                    ]
                });


                $('#add_user').on('click', function() {
                    $('#createUser').modal('show');
                });

                $(document).ready(function() {
                    $('#addUserForm').on('submit', function(e) {
                        e.preventDefault();

                        let $submitButton = $('#addUserForm button[type="submit"]');
                        $submitButton.prop('disabled',
                            true); // Disable button to prevent multiple submissions

                        $.ajax({
                            type: 'POST',
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            },
                            url: "<?php echo e(route('add_admin_form')); ?>",
                            data: $(this).serialize(),
                            success: function(response) {
                                if (response.success) {
                                    $('#createUser').modal('hide'); // Close the modal
                                    $('#user_table').DataTable().ajax
                                        .reload(); // Reload the DataTable
                                    $('#addUserForm')[0].reset(); // Reset the form
                                    toastr.success(response
                                        .message); // Display success message
                                } else {
                                    // Handle validation errors
                                    let errorsQueue = [];

                                    if (response.errors) {
                                        $.each(response.errors, function(key, errors) {
                                            $.each(errors, function(index, error) {
                                                errorsQueue.push(
                                                    error
                                                ); // Add each error to the queue
                                            });
                                        });
                                    }

                                    // Display errors one by one
                                    displayErrors(errorsQueue);
                                }
                            },
                            error: function(xhr) {
                                let errorsQueue = [];
                                let errorMessage = 'An error occurred. Please try again.';

                                if (xhr.status ===
                                    422) { // Validation error from the backend
                                    let errors = xhr.responseJSON.errors;
                                    $.each(errors, function(key, error) {
                                        $.each(error, function(index, msg) {
                                            errorsQueue.push(
                                                msg
                                            ); // Add each validation error to the queue
                                        });
                                    });
                                } else if (xhr.responseJSON && xhr.responseJSON.message) {
                                    errorsQueue.push(xhr.responseJSON
                                        .message); // Add general error message to the queue
                                }

                                // Display errors one by one
                                displayErrors(errorsQueue);
                            },
                            complete: function() {
                                $submitButton.prop('disabled',
                                    false
                                ); // Re-enable the submit button after the request completes
                            }
                        });
                    });

                    function displayErrors(errorsQueue) {
                        if (errorsQueue.length > 0) {
                            let error = errorsQueue.shift(); // Get the next error message
                            toastr.error(error, '', {
                                onHidden: function() {
                                    // Check if there are more errors to show
                                    if (errorsQueue.length > 0) {
                                        displayErrors(
                                            errorsQueue
                                        );
                                    }
                                }
                            });
                        }
                    }
                });


                $('body').on('click', '#delete_user', function() {
                    var id = $(this).data('id');

                    $.ajax({
                        type: "DELETE",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('delete_admin', ['id' => ':id'])); ?>"
                            .replace(':id', id),
                        success: function(response) {
                            $('#user_table').DataTable().ajax.reload();
                            // Show success Toastr message
                            toastr.success('User deleted successfully');
                        },
                        error: function(xhr) {
                            // Display error Toastr message
                            let errorMessage = 'An error occurred while deleting the User.';
                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorMessage = xhr.responseJSON.message;
                            }
                            toastr.error(errorMessage);
                        }
                    });
                });

                $('body').on('click', '#editallowtbtn', function() {
                    var id = $(this).data('id');
                    $.ajax({
                        type: "GET",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('get_admin', ['id' => ':id'])); ?>".replace(':id', id),
                        success: function(response) {
                            if (response.status === 404) {
                                $('#updateUser').modal('hide');
                                toastr.error('User not found.');
                            } else {
                                $('#updateUser').modal('show');
                                var user = response;
                                console.log(user) // Response data is already the user info
                                $('#user_id').val(user.id);
                                $('#update_name').val(user.name); // Set name
                                $('#update_email').val(user.email); // Set email
                                $('#update_role').val(user.role); // Set email

                            }
                        },
                        error: function(xhr) {
                            toastr.error('An error occurred while fetching the User.');
                        }
                    });
                });
                let errorsQueue = []; // Queue to store errors

                $('#updateUserForm').on('submit', function(e) {
                    e.preventDefault();

                    var id = $('#user_id').val(); // Get the user ID

                    let $submitButton = $('#updateUserForm button[type="submit"]');
                    $submitButton.prop('disabled', true); // Disable button to prevent multiple submissions

                    $.ajax({
                        type: 'PUT',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('update_admin_form', ['id' => ':id'])); ?>".replace(':id', id),
                        data: $(this).serialize(),
                        success: function(response) {
                            if (response.success) {
                                $('#updateUser').modal('hide');
                                $('#user_table').DataTable().ajax.reload(); // Reload DataTable
                                toastr.success(response.message); // Display success message
                                $('#updateUserForm')[0].reset(); // Reset the form
                            } else {
                                handleErrors(response.errors); // Handle validation or other errors
                            }
                        },
                        error: function(xhr) {
                            if (xhr.status === 422 && xhr.responseJSON.errors) {
                                // Validation error from the backend
                                handleErrors(xhr.responseJSON.errors);
                            } else if (xhr.responseJSON && xhr.responseJSON.message) {
                                // General error message
                                errorsQueue.push(xhr.responseJSON.message);
                                displayErrors(); // Display the general error message
                            } else {
                                errorsQueue.push('An error occurred. Please try again.');
                                displayErrors(); // Display fallback error
                            }
                        },
                        complete: function() {
                            $submitButton.prop('disabled',
                            false); // Re-enable the submit button after the request completes
                        }
                    });
                });

                function handleErrors(errors) {
                    // Clear the queue first
                    errorsQueue = [];

                    // Process the validation errors and add to the queue
                    $.each(errors, function(key, error) {
                        $.each(error, function(index, msg) {
                            errorsQueue.push(msg); // Add each validation error to the queue
                        });
                    });

                    displayErrors(); // Display the errors one by one
                }

                function displayErrors() {
                    if (errorsQueue.length > 0) {
                        let error = errorsQueue.shift(); // Get the next error message
                        toastr.error(error, '', {
                            onHidden: function() {
                                // Check if there are more errors to show
                                if (errorsQueue.length > 0) {
                                    displayErrors(); // Recursively display the next error
                                }
                            }
                        });
                    }
                }

                $(document).on('click', '#updateStatusButton', function() {
                    var id = $(this).data('id'); // Get the ID from the clicked button
                    $.ajax({
                        type: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr(
                                'content') // Laravel CSRF token
                        },
                        url: "<?php echo e(route('update_user_status')); ?>", // Your route for updating the status
                        data: {
                            id: id // Pass the ID as data in the request
                        },
                        success: function(response) {
                            if (response.success) {
                                toastr.success(response.message); // Show success message
                                // Optionally reload table or update UI
                                $('#user_table').DataTable().ajax.reload();
                            } else {
                                toastr.error(response.message); // Show error message
                            }
                        },
                        error: function(xhr) {
                            let response = xhr.responseJSON || {};
                            toastr.error(response.message || 'An error occurred.');
                        }
                    });
                });


            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/microsolscom/public_html/devioo-hrm/resources/views/super_admin/manage_users/manage_users.blade.php ENDPATH**/ ?>