



<?php $__env->startSection('content'); ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {
        $("#payment").click(function() {
            $('#PayBtn').hide();
            var printableSectionClone = $(".PrintBody").clone();
            
            // Remove script tags from the cloned section
            printableSectionClone.find('script').remove();

            var printContainer = $("<div>").append(printableSectionClone);

            $("body").children().hide();
            $("body").append(printContainer);

            window.print();

            printContainer.remove();
            $("body").children().show();
            $("body").find('script').hide();
            $('#PayBtn').show();
        });
    });
</script>

<div class="content-wrapper">
    <div class="row page-header">
        <h3 class="col-md-6 page-title">Salary List</h3>
        <nav class="col-md-6 text-right" aria-label="breadcrumb">
            <a href="<?php echo e(route('employees_index')); ?>" class="btn btn-sm btn-outline-primary">
                <i class="fa fa-list mr-sm-2"></i>Employees List
            </a>
        </nav>
        <nav class="col-12" aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Pay Slip</li>
            </ol>
        </nav>
    </div>
    <div class="container">
        <div class="card p-5">
            <div class="d-flex justify-content-end">
                <a id="payment" class="btn bg-danger text-white" target="_blank">Print <i class="fas fa-print"></i></a>
            </div>
            <div class="row PrintBody">
                <div class="col-md-12">
                    <div class="text-center">
                        <img src="<?php echo e(asset('assets/images/hexon-logo.png')); ?>" alt="Hexon Logo" style="width: 100%; max-width:250px;">
                    </div>
                    <div class="text-center mt-3 mb-2">
                        <h3 class="fw-bold">Payslip</h3>
                        <span class="fw-normal">Payment slip for the month of <?php echo e($data['salary_month']); ?></span>
                    </div>
                    <div>
                        <h3 class="text-uppercase"><?php echo e($data['employee']['user_profile']['user']['name']); ?></h3>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div>
                                <span class="fw-bolder w-25 d-inline-block">Email :</span>
                                <small class="ms-3"><?php echo e($data['employee']['user_profile']['user']['email']); ?></small>
                            </div>
                            <div>
                                <span class="fw-bolder w-25 d-inline-block">Phone :</span>
                                <small class="ms-3"><?php echo e($data['employee']['user_profile']['phone']); ?></small>
                            </div>
                            <div>
                                <span class="fw-bolder w-25 d-inline-block">CNIC :</span>
                                <small class="ms-3"><?php echo e($data['employee']['user_profile']['cnic']); ?></small>
                            </div>
                            <div>
                                <span class="fw-bolder w-25 d-inline-block">Gender :</span>
                                <small class="ms-3 text-capitalize"><?php echo e($data['employee']['user_profile']['gender']); ?></small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div>
                                <span class="fw-bolder w-25 d-inline-block">Department :</span>
                                <small class="ms-3 text-capitalize"><?php echo e($data['employee']['department']['department']); ?></small>
                            </div>
                            <div>
                                <span class="fw-bolder w-25 d-inline-block">Designation :</span>
                                <small class="ms-3 text-capitalize"><?php echo e($data['employee']['designation']['designation']); ?></small>
                            </div>
                            <div>
                                <span class="fw-bolder w-25 d-inline-block">Shift :</span>
                                <small class="ms-3 text-capitalize"><?php echo e($data['employee']['shift']['shift']); ?></small>
                            </div>
                            <div>
                                <span class="fw-bolder w-25 d-inline-block">Duty Time :</span>
                                <small class="ms-3">9:00 Hr</small>
                            </div>
                        </div>
                    </div>

                    <table class="mt-4 table table-bordered">
                        <thead class="bg-danger text-white">
                            <tr>
                                <th scope="col">Earnings</th>
                                <th scope="col">Amount</th>
                                <th class="bg-white text-center text-dark">-</th>
                                <th scope="col">Deductions</th>
                                <th scope="col">Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Basic Salary</td>
                                <td>RS <?php echo e(number_format($data['salary'], 2)); ?> -/<sub>only</sub></td>
                                <td class="text-center">-</td>
                                <td>Deductions</td>
                                <td>RS <?php echo e(number_format($data['deductions'], 2)); ?> -/<sub>only</sub></td>
                            </tr>
                            <tr>
                                <td>Bonus</td>
                                <td>RS <?php echo e(number_format($data['bonusAmount'], 2)); ?> -/<sub>only</sub></td>
                                <td class="text-center">-</td>
                                <td>Installment</td>
                                <td>RS <?php echo e(number_format($data['loan_installment'], 2)); ?> -/<sub>only</sub></td>
                            </tr>
                            <tr>
                                <td>Increment</td>
                                <td>RS <?php echo e(number_format($data['increments'], 2)); ?> -/<sub>only</sub></td>
                                <td class="text-center">-</td>
                                <td>Tax</td>
                                <td>RS <?php echo e(number_format($data['tax'], 2)); ?> -/<sub>only</sub></td>


                            </tr>
                            <tr class="border-top">
                                <th>Total Earning</th>
                                <td>RS <?php echo e(number_format($data['net_pay'], 2)); ?> -/<sub>only</sub></td>
                                <td class="text-center">-</td>
                                <th>Total Deductions</th>
                                <td>RS <?php echo e(number_format($data['deductions'], 2)); ?> -/<sub>only</sub></td>
                            </tr>
                        </tbody>
                    </table>
                    
                    <div class="row mt-4 mb-3">
                        <div class="col-md-6">
                            <div class="p-2 font-weight-bold" style="font-size:20px;">
                                <span>Net Salary : </span>
                                <td>RS <?php echo e(number_format($data['net_pay_after_tax'], 2)); ?> -/<sub>only</sub></td>
                            </div>
                        </div>
                        <div class="col-md-6 text-right">
                            <div class="p-2 text-left border-bottom">
                                <span>Authorised Signatory : </span>
                            </div>
                        </div>
                        <div class="col-md-8 mt-4 text-right font-weight-bold text-capitalize">
                            <span>In Words : </span><?php echo e($data['total_amount_in_words']); ?> <sub>-/Rupees Only</sub>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\devioo_hrm\resources\views/admin/employee/salary_slip.blade.php ENDPATH**/ ?>