<?php $__env->startSection('content'); ?>
    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    Document List
                </h3>
                <nav class="col-md-6 text-right" aria-label="breadcrumb">
                    <button data-bs-toggle="modal" id="add_document" class="btn btn-sm btn-outline-primary">
                        <i class="fa fa-plus-circle mr-sm-2"></i>Create Document</button>
                </nav>
                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a
                                style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Document List
                        </li>
                    </ol>
                </nav>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table id="document_table" class="data_table table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>id</th>
                                            <th>Document</th>
                                            <th>Name</th>
                                            <th>Remind Before</th>
                                            <th>Expiry Date</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>




    <div class="modal fade" id="createDocument" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Add Document</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="addDocumentForm" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body" style="padding: 35px 15px !important">
                        <label>Employee</label>
                        <select type="text" class="form-control" id="employee_id" name="employee_id"
                            placeholder="Enter Education" required>
                            <option selected disabled>Select Employe</option>
                            <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($employee['id']); ?>"><?php echo e($employee['name']); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>

                        <label for="document" class="mt-4">Document</label>
                        <input type="file" class="form-control" id="document" name="document" required>

                        <label for="name" class="mt-4">Name</label>
                        <input type="text" class="form-control" id="name" name="name" required>

                        <label for="remind_date" class="mt-4">Expire Date</label>
                        <input type="date" class="form-control" id="expiry_date" name="expiry_date" required>


                        <label class="mt-4">Remind Before</label>
                        <select type="text" class="form-control" id="remind_before" name="remind_before"
                            placeholder="Enter Education" required>
                            <option selected disabled>Select Status</option>
                            <option value="7">7 Days</option>
                            <option value="15">15 Days</option>
                            <option value="30">30 Days</option>
                        </select>
                        <label class="mt-4">Status</label>
                        <select type="text" class="form-control" id="status" name="status"
                            placeholder="Enter Education" required>
                            <option selected disabled>Select Status</option>
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Add</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="updateDocument" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Update Document</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="updateDocumentForm" enctype="multipart/form-data" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="document_id" id="document_id">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        <label>Employee</label>
                        <select type="text" class="form-control" id="update_employee_id" name="employee_id"
                            placeholder="Enter Education" required>
                            <option selected disabled>Select Employe</option>
                            <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($employee['id']); ?>"><?php echo e($employee['name']); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>

                        <label for="update_document" class="mt-4">Document</label>
                        <input type="file" class="form-control" id="update_document" name="document">

                        <label for="update_name" class="mt-4">Name</label>
                        <input type="text" class="form-control" id="update_name" name="name" required>

                        <label for="update_remind_date" class="mt-4">Date</label>
                        <input type="date" class="form-control" id="update_expiry_date" name="expiry_date">

                        <label class="mt-4">Remind Before</label>
                        <select type="text" class="form-control" id="update_remind_before" name="remind_before"
                            placeholder="Enter Education" required>
                            <option selected disabled>Select Status</option>
                            <option value="7">7 Days</option>
                            <option value="15">15 Days</option>
                            <option value="30">30 Days</option>
                        </select>
                        <label for="status" class="mt-4">Status</label>
                        <select name="status" id="update_status" class="form-control" required>
                            <option selected disabled>Select Status</option>
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>
                    </div>
                    <div class="modal-footer mt-4">
                        <button type="submit" class="btn btn-success">Update</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>



    




    <?php $__env->startPush('js'); ?>
        <script>
            $(document).ready(function() {
            
                var session_data = <?php echo json_encode(session()->all(), 15, 512) ?>;
                $('#document_table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: '<?php echo e(env('API_BASE_URL')); ?>/documents/index',
                        beforeSend: function(xhr) {
                            xhr.setRequestHeader('Authorization', session_data.bearer_token);
                        },
                        complete: function(response) {
                            // After the API call is complete, restore the session data
                            if (response.status === 200) {
                                $.ajax({
                                    type: 'GET',
                                    url: '<?php echo e(route('restore_session_data')); ?>',
                                    data: {
                                        bearer_token: session_data.bearer_token,
                                        role: session_data.role,
                                        permissions: session_data.permissions,
                                        org_id: session_data.org_id,
                                        id: session_data.id,
                                        currency: session_data.currency,
                                        logo: session_data.logo,
                                        employee_id: session_data.employee_id,
                                        user_name: session_data.user_name,
                                        designation: session_data.designation,
                                    },
                                    success: function(data) {
                                        if (data.success) {
                                            console.log("Session restored successfully");
                                        } else {
                                            console.error("Failed to restore session");
                                        }
                                        console.log(data);
                                    },
                                    error: function(xhr) {
                                        console.error("Error restoring session:", xhr);
                                    }
                                });

                            }
                        }
                    },
                    columns: [{
                            data: 'count',
                            name: 'count'
                        },
                        {
                            data: 'id',
                            name: 'id',
                            visible: false
                        },
                        {
                            data: 'download',
                            name: 'download'
                        },
                        {
                            data: 'name',
                            name: 'name'
                        },
                        {
                            data: 'remind_before',
                            name: 'remind_before',
                            render: function(data) {
                                return new Date(data).toLocaleDateString('en-GB', {
                                    day: '2-digit',
                                    month: 'short',
                                    year: 'numeric'
                                });
                            }
                        },
                        {
                            data: 'expiry_date',
                            name: 'expiry_date',
                            render: function(data) {
                                return new Date(data).toLocaleDateString('en-GB', {
                                    day: '2-digit',
                                    month: 'short',
                                    year: 'numeric'
                                });
                            }
                        },
                        {
                            data: 'status',
                            name: 'status'
                        },
                        {
                            data: null,
                            name: 'action',
                            render: function(data, type, row) {
                                return `
                <div class="dropdown">
                    <a style="font-size: 19px; color:black; text-decoration: none;" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        ⋮
                    </a>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuLink" x-placement="bottom-start" style="position: absolute; transform: translate3d(0px, 21px, 0px); top: 0px; left: 0px; will-change: transform;">
                        <button data-id="${row.id}" id="editdocumenttbtn" class="dropdown-item text-primary">
                            <i class="fa fa-pen mr-2"></i> Edit
                        </button>
                        <button data-id="${row.id}" id="delete_document" class="dropdown-item text-danger">
                            <i class="far fa-trash-alt mr-2"></i> Delete
                        </button>
                    </div>
                </div>
                `;
                            }
                        }
                    ]
                });



                $('#add_document').on('click', function() {
                    $('#createDocument').modal('show');
                });

                $('#addDocumentForm').on('submit', function(e) {
                    e.preventDefault(); // Prevent default form submission

                    let $submitButton = $('#addDocumentForm button[type="submit"]');
                    $submitButton.prop('disabled',
                        true); // Disable the submit button to avoid multiple submissions

                    // Create a new FormData object to handle file uploads
                    let formData = new FormData(this);

                    $.ajax({
                        url: '<?php echo e(route('add_document_form')); ?>', // Ensure this matches your route
                        type: 'POST',
                        data: formData,
                        contentType: false, // For multipart form data
                        processData: false, // Don't process the data (it's a file upload)
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr(
                                'content'), // Add CSRF token header
                        },
                        success: function(response) {
                            if (response.success) {
                                $('#createDocument').modal('hide'); // Hide the modal
                                $('#document_table').DataTable().ajax
                                    .reload(); // Reload DataTable if needed
                                $('#addDocumentForm')[0].reset(); // Reset the form
                                toastr.success(response.message); // Show success message
                            } else {
                                toastr.error(response.message); // Show API error message
                            }
                        },
                        error: function(xhr) {
                            // Handle client-side or server-side errors
                            let response = xhr.responseJSON;

                            if (xhr.status === 422 && response.errors) {
                                // Show validation errors one by one
                                let errors = response.errors;
                                let errorMessages = Object.values(errors)
                                    .flat(); // Flatten all errors into a single array

                                // Display each error message one by one using Toastr
                                errorMessages.forEach(function(message) {
                                    toastr.error(message); // Show error message in Toastr
                                });
                            } else if (response && response.message) {
                                // Show general API error if available
                                toastr.error(response.message);
                            } else {
                                // Default error message for unexpected cases
                                toastr.error('An unexpected error occurred. Please try again.');
                            }
                        },
                        complete: function() {
                            $submitButton.prop('disabled',
                                false); // Re-enable the submit button after the request completes
                        }

                    });
                });

                // Function to display the next error in the queue
                function displayNextUpdateError(errors) {
                    if (errors.length > 0) {
                        let error = errors.shift(); // Get the next error message
                        toastr.error(error, '', {
                            onHidden: function() {
                                displayNextUpdateError(errors); // Show the next error in the queue
                            }
                        });
                    }
                }


                $('body').on('click', '#delete_document', function() {
                    var id = $(this).data('id');

                    $.ajax({
                        type: "DELETE",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('delete_document', ['id' => ':id'])); ?>"
                            .replace(':id', id),
                        success: function(response) {
                            $('#document_table').DataTable().ajax.reload();
                            // Show success Toastr message
                            toastr.success('Document deleted successfully');
                        },
                        error: function(xhr) {
                            // Display error Toastr message
                            let errorMessage = 'An error occurred while deleting the Document.';
                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorMessage = xhr.responseJSON.message;
                            }
                            toastr.error(errorMessage);
                        }
                    });
                });

                $('body').on('click', '#editdocumenttbtn', function() {
                    var id = $(this).data('id');

                    $.ajax({
                        type: "GET",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('get_document', ['id' => ':id'])); ?>"
                            .replace(':id', id),
                        success: function(response) {

                            if (response.status === 404) {
                                $('#updateDocument').modal('hide');
                                toastr.error('Document not found.');
                            } else {
                                $('#updateDocument').modal('show');
                                var document =
                                    response; // response is already the department data
                                $('#document_id').val(document.id);
                                $('#update_name').val(document.name);
                                $('#update_expiry_date').val(document.expiry_date);
                                $('#update_remind_before').val(document.remind_before);
                                $('#update_employee_id').val(document.employee_id);
                                $('#update_status').val(document.status);
                            }
                        },
                        error: function(xhr) {

                            toastr.error('An error occurred while fetching the Document.');
                        }
                    });
                });
                $('#updateDocumentForm').on('submit', function(e) {
                    e.preventDefault(); // Prevent default form submission

                    var id = $('#document_id').val(); // Get the document ID

                    let $submitButton = $('#updateDocumentForm button[type="submit"]');
                    $submitButton.prop('disabled', true); // Disable the submit button

                    let formData = new FormData(this); // Use FormData to handle file upload

                    $.ajax({
                        type: 'POST',
                        url: "<?php echo e(route('update_document_form', ['id' => ':id'])); ?>".replace(':id', id),
                        data: formData,
                        contentType: false, // Required for file uploads
                        processData: false, // Required for file uploads
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function(response) {
                            if (response.success) {
                                $('#updateDocument').modal('hide'); // Hide the modal
                                $('#document_table').DataTable().ajax.reload(); // Reload DataTable
                                toastr.success(response.message); // Show success message
                                $('#updateDocumentForm')[0].reset(); // Reset the form
                            } else {
                                // Show the first error message from the response
                                toastr.error(response.message || 'An error occurred.');
                            }
                        },
                        error: function(xhr) {
                            let errorMessage = 'An unexpected error occurred.';
                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorMessage = xhr.responseJSON
                                    .message; // Use API error message if available
                            }
                            toastr.error(errorMessage); // Show error message
                        },
                        complete: function() {
                            $submitButton.prop('disabled', false); // Re-enable the submit button
                        }
                    });
                });

                // $('body').on('click', '#viewDocumnet', function() {
                //     var id = $(this).data('id');

                //     $.ajax({
                //         type: "GET",
                //         headers: {
                //             'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                //         },
                //         url: "<?php echo e(route('get_document', ['id' => ':id'])); ?>"
                //             .replace(':id', id),
                //         success: function(response) {

                //             if (response.status === 404) {
                //                 $('#documentModal').modal('hide');
                //                 toastr.error('Document not found.');
                //             } else {
                //                 $('#documentModal').modal('show');
                //                 var document =
                //                     response; // response is already the department data
                //                 $('#view_document').val(document.document);
                //             }
                //         },
                //         error: function(xhr) {

                //             toastr.error('An error occurred while fetching the Document.');
                //         }
                //     });
                // });

            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/microsols/public_html/hrm.microsols.com/resources/views/admin/settings/document.blade.php ENDPATH**/ ?>