<?php $__env->startSection('content'); ?>
    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    Petty Cash List
                </h3>
                <nav class="col-md-6 text-right" aria-label="breadcrumb">
                    
                    <button data-bs-toggle="modal" id="add_petty_cash" class="btn btn-sm btn-outline-primary">
                        <i class="fa fa-plus-circle mr-sm-2"></i>Create Petty Cash</button>
                </nav>
                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">
                                Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Petty Cash List</li>
                    </ol>

                </nav>

            </div>
            <div>
                        <p class="btn btn-sm btn-primary" id="balance">Available Balance: 970</p>
                    </div>
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table id="petty_cash_table" class="data_table table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>id</th>
                                            <th>Amount</th>
                                            <th>Date</th>
                                            <th>Description</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Petty Cash Modal -->
    <div class="modal fade" id="createPettyCash" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Add Petty Cash</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="addPettyCashForm" method="POST">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        <?php echo csrf_field(); ?>

                        <label for="amount">Amount</label>
                        <input class="form-control" type="number" id="amount" name="amount" placeholder="Enter amount" required>

                        <label class="mt-4">Date</label>
                        <input class="form-control" type="date" id="date" name="date" placeholder="Enter date" required>

                        <label class="mt-4">Description</label>
                        <textarea class="form-control" type="text" id="description" name="description" rows="5" placeholder="Enter description" required></textarea>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Add</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Update Petty Cash Modal -->
    <div class="modal fade" id="updatePettyCash" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Update Petty Cash</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="updatePettyCashForm">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="petty_cash_id" id="petty_cash_id">

                        <label for="update_amount">Amount</label>
                        <input class="form-control" type="number" id="update_amount" name="amount" placeholder="Enter amount" required>

                        <label class="mt-4">Date</label>
                        <input class="form-control" type="date" id="update_date" name="date" placeholder="Enter date" required>

                        <label class="mt-4">Description</label>
                        <textarea class="form-control" type="text" id="update_description" name="description" rows="5" placeholder="Enter description" required></textarea>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Update</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php $__env->startPush('js'); ?>
        <script>
            $(document).ready(function() {
                var session_data = <?php echo json_encode(session()->all(), 15, 512) ?>;

                $('#petty_cash_table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: '<?php echo e(env('API_BASE_URL')); ?>/petty/cashes?employee_id='+session_data.employee_id,
                        beforeSend: function(xhr) {
                            xhr.setRequestHeader('Authorization', session_data.bearer_token);
                        },
                        complete: function(response) {
                            if (response.status === 200) {
                                var balance = response.responseJSON.balance;
                                $('#balance').text('Available Balance: ' + balance);
                                $.ajax({
                                    type: 'GET',
                                    url: '<?php echo e(route('restore_session_data')); ?>',
                                    data: {
                                        bearer_token: session_data.bearer_token,
                                        role: session_data.role,
                                        permissions: session_data.permissions,
                                        org_id: session_data.org_id,
                                        id: session_data.id,
                                        logo: session_data.logo,
                                        currency: session_data.currency,
                                        employee_id: session_data.employee_id,
                                        user_name: session_data.user_name,
                                        designation: session_data.designation,
                                    },
                                    success: function(data) {
                                        if (data.success) {
                                            console.log("Session restored successfully");
                                        } else {
                                            console.error("Failed to restore session");
                                        }
                                        console.log(data);
                                    },
                                    error: function(xhr) {
                                        console.error("Error restoring session:", xhr);
                                    }
                                });

                            }
                        }
                    },
                    columns: [
                        { data: 'count', name: 'count' },
                        { data: 'id', name: 'id', visible: false },
                        { data: 'amount', name: 'amount' },
                        { data: 'date', name: 'date' },
                        { data: 'description', name: 'description' },
                        {
                            data: null,
                            name: 'action',
                            render: function(data, type, row) {
                                return `
                                    <div class="dropdown">
                                        <a style="font-size: 19px; color:black; text-decoration: none;" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            ⋮
                                        </a>
                                        <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                                            <button data-id="${row.id}" id="editPettyCashBtn" class="dropdown-item text-primary">
                                                <i class="fa fa-pen mr-2"></i> Edit
                                            </button>
                                            <button data-id="${row.id}" id="deletePettyCash" class="dropdown-item text-danger">
                                                <i class="far fa-trash-alt mr-2"></i> Delete
                                            </button>
                                        </div>
                                    </div>
                                `;
                            }
                        }
                    ]
                });

                // Add petty cash
                $('#add_petty_cash').on('click', function() {
                    $('#createPettyCash').modal('show');
                });

                $('#addPettyCashForm').on('submit', function(e) {
                    e.preventDefault();
                    let $submitButton = $('#addPettyCashForm button[type="submit"]');
                    $submitButton.prop('disabled', true);

                    $.ajax({
                        type: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('petty_cash.store')); ?>",
                        data: $(this).serialize(),
                        success: function(response) {
                            if (response.success) {
                                $('#createPettyCash').modal('hide');
                                $('#petty_cash_table').DataTable().ajax.reload();
                                $('#addPettyCashForm')[0].reset();
                                toastr.success(response.message);
                            } else {
                                toastr.error(response.message);
                            }
                        },
                        error: function(xhr) {
                            toastr.error('An error occurred');
                        },
                        complete: function() {
                            $submitButton.prop('disabled', false);
                        }
                    });
                });

                // Edit petty cash
                $('body').on('click', '#editPettyCashBtn', function() {
                    var id = $(this).data('id');

                    $.ajax({
                        type: "GET",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('petty_cash.show', ['id' => ':id'])); ?>".replace(':id', id),
                        success: function(response) {
                            $('#updatePettyCash').modal('show');
                            $('#petty_cash_id').val(response.id);
                            $('#update_amount').val(response.amount);
                            $('#update_date').val(response.date);
                            $('#update_description').val(response.description);
                        },
                        error: function(xhr) {
                            toastr.error('An error occurred while fetching the Petty Cash details.');
                        }
                    });
                });

                $('#updatePettyCashForm').on('submit', function(e) {
                    e.preventDefault();
                    var id = $('#petty_cash_id').val();

                    let $submitButton = $('#updatePettyCashForm button[type="submit"]');
                    $submitButton.prop('disabled', true);

                    $.ajax({
                        type: 'PUT',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('petty_cash.update', ['id' => ':id'])); ?>".replace(':id', id),
                        data: $(this).serialize(),
                        success: function(response) {
                            if (response.success) {
                                $('#updatePettyCash').modal('hide');
                                $('#petty_cash_table').DataTable().ajax.reload();
                                toastr.success(response.message);
                            } else {
                                toastr.error(response.message);
                            }
                        },
                        error: function(xhr) {
                            toastr.error('An error occurred while updating the Petty Cash.');
                        },
                        complete: function() {
                            $submitButton.prop('disabled', false);
                        }
                    });
                });

                // Delete petty cash
                $('body').on('click', '#deletePettyCash', function() {
                    var id = $(this).data('id');

                    $.ajax({
                        type: "DELETE",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('petty_cash.destroy', ['id' => ':id'])); ?>".replace(':id', id),
                        success: function(response) {
                            $('#petty_cash_table').DataTable().ajax.reload();
                            toastr.success('Petty Cash deleted successfully');
                        },
                        error: function(xhr) {
                            toastr.error('An error occurred while deleting the Petty Cash.');
                        }
                    });
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/microsols/public_html/hrm.microsols.com/resources/views/admin/employee/petty_cash.blade.php ENDPATH**/ ?>