<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use App\DataTables\EmployeeDataTable;
use Illuminate\Support\Facades\Redirect;

class EmployeeController extends Controller
{
    private function fetch_departments(): array
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->get("{$apiBaseUrl}/departments");

        if ($response->successful()) {
            $departments = $response->json()['departments'] ?? [];
            // Extract only the necessary columns
            $departments = array_map(function ($departments) {
                return [
                    'id' => $departments['id'],
                    'department' => $departments['department'],
                ];
            }, $departments);

            return $departments;
        }

        return [];
    }
    private function fetch_designations(): array
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->get("{$apiBaseUrl}/designations");

        if ($response->successful()) {
            $designations = $response->json()['designations'] ?? [];
            // Extract only the necessary columns
            $designations = array_map(function ($designations) {
                return [
                    'id' => $designations['id'],
                    'designation' => $designations['designation'],
                ];
            }, $designations);

            return $designations;
        }

        return [];
    }
    private function fetch_education(): array
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->get("{$apiBaseUrl}/education");

        if ($response->successful()) {
            $education = $response->json()['educations'] ?? [];
            // Extract only the necessary columns
            $education = array_map(function ($education) {
                return [
                    'id' => $education['id'],
                    'education' => $education['education'],
                ];
            }, $education);

            return $education;
        }

        return [];
    }
    private function fetch_allowances(): array
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->get("{$apiBaseUrl}/allowances");

        if ($response->successful()) {
            $allowances = $response->json()['allowances'] ?? [];
            // Extract only the necessary columns
            $allowances = array_map(function ($allowances) {
                return [
                    'id' => $allowances['id'],
                    'allowance' => $allowances['allowance'],
                ];
            }, $allowances);

            return $allowances;
        }

        return [];
    }
    private function fetch_job_types(): array
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->get("{$apiBaseUrl}/job_types");

        if ($response->successful()) {
            $job_types = $response->json()['job_types'] ?? [];
            // Extract only the necessary columns
            $job_types = array_map(function ($job_types) {
                return [
                    'id' => $job_types['id'],
                    'job_type' => $job_types['job_type'],
                ];
            }, $job_types);

            return $job_types;
        }

        return [];
    }
    private function fetch_work_history(): array
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->get("{$apiBaseUrl}/work_history");

        if ($response->successful()) {
            $work_history = $response->json()['work_history'] ?? [];
            // Extract only the necessary columns
            $work_history = array_map(function ($work_history) {
                return [
                    'id' => $work_history['id'],
                    'work_history' => $work_history['work_history'],
                ];
            }, $work_history);

            return $work_history;
        }

        return [];
    }
    private function fetch_shift(): array
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->get("{$apiBaseUrl}/shift");

        if ($response->successful()) {
            $shift = $response->json()['shifts'] ?? [];
            // Extract only the necessary columns
            $shift = array_map(function ($shift) {
                return [
                    'id' => $shift['id'],
                    'shift' => $shift['shift'],
                ];
            }, $shift);

            return $shift;
        }

        return [];
    }
    private function fetch_salary(): array
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->get("{$apiBaseUrl}/salary");

        if ($response->successful()) {
            $salary = $response->json()['salaries'] ?? [];
            // Extract only the necessary columns
            $salary = array_map(function ($salary) {
                return [
                    'id' => $salary['id'],
                    'salary' => $salary['salary'],
                ];
            }, $salary);

            return $salary;
        }

        return [];
    }
    private function fetch_salary_type(): array
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->get("{$apiBaseUrl}/salary_type");

        if ($response->successful()) {
            $salary_type = $response->json()['salary_types'] ?? [];
            // Extract only the necessary columns
            $salary_type = array_map(function ($salary_type) {
                return [
                    'id' => $salary_type['id'],
                    'salary_type' => $salary_type['salary_type'],
                ];
            }, $salary_type);

            return $salary_type;
        }

        return [];
    }
    public function create_employee()
    {
        $departments = $this->fetch_departments();
        $designations = $this->fetch_designations();
        $educations = $this->fetch_education();
        $allowances = $this->fetch_allowances();
        $job_types = $this->fetch_job_types();
        $work_history = $this->fetch_work_history();
        $shifts = $this->fetch_shift();
        $salaries = $this->fetch_salary();
        $salary_types = $this->fetch_salary_type();

        return view('admin.employee.create_employee', compact('departments', 'designations', 'educations', 'allowances', 'job_types', 'work_history', 'shifts', 'salaries', 'salary_types'));
    }

    public function index()
    {
        return view('admin.employee.employee');
    }

    public function getEmployeeList(EmployeeDataTable $dataTable)
    {
        return $dataTable->ajax();
    }
    public function delete_employee($id)
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->delete("{$apiBaseUrl}/employees/{$id}");

        if ($response->successful()) {
            return response()->json(['success' => true, 'message' => 'Employee deleted successfully']);
        } else {
            // Ensure the error message is correctly fetched from the API response
            $error = $response->json();
            return response()->json([
                'success' => false,
                'message' => $error['message'] ?? 'Unable to delete Employee'
            ], $response->status());
        }
    }



    public function fetchPayslip(Request $request)
    {
        // Validate form data
        $validated = $request->validate([
            'employee_id' => 'required|numeric',
            'month' => 'required|date_format:Y-m',
        ]);

        $employee_id = $validated['employee_id'];
        $month = $validated['month'];

        // Build the correct API URL: /payslip/{employee_id}?month={month}
        $api_url = "https://microsols.com.au/devioo/public/api/payslip/{$employee_id}?month={$month}";

        // Retrieve the token from session
        $token = session('bearer_token');

        if (!$token) {
            return redirect()->back()->with('error', 'Authentication token not found. Please login again.');
        }

        // Make the API request with the token
        $response = Http::withHeaders([
            'Authorization' => $token,
            'Accept' => 'application/json',
        ])->get($api_url);

       

        // Check if the API request was successful
        if ($response->successful()) {
            // Get the response data
            $data = $response->json();

            // Pass the entire `data` array to the view
            return view('admin.employee.salary_slip', ['data' => $data['data']]);
        } else {
            // Handle errors (e.g., API request failed)
            return redirect()->back()->with('error', 'Failed to fetch payslip data');
        }
    }



    
    
}


