<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;

class AuthController extends Controller
{
    public function login_view()
    {
        // Redirect to the home page if already logged in
        if (session()->has('bearer_token')) {
            return redirect()->route('home');
        }

        return view('auth.login');
    }
    public function login(Request $request)
    {
        // Validate the request
        $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);
    
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::post("$apiBaseUrl/login", [
            'email' => $request->email,
            'password' => $request->password,
        ]);
    
        if ($response->successful()) {
            $data = $response->json();
            $token = 'Bearer ' . $data['access_token'];
            $role = $data['role'];
            $permissions = $data['permissions'];
            $org_id = $data['org_id'];
    
            // Store token, role, and permissions in the session
            session([
                'bearer_token' => $token,
                'role' => $role,
                'permissions' => $permissions,
                'org_id'=>$org_id
            ]);
    
            // Redirect to the dashboard with a success message
            return redirect('/')->with('success', 'Logged in successfully');
        }
    
        // Pass the API response message to the login view as error
        $message = $response->json('message', 'Credentials did not match');
        return redirect()->route('login_view')->with('error', $message);
    }
    
    public function logout(Request $request)
    {
        // Get the bearer token from the session
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        // Send request to external API
        $response = Http::withToken($token)->post("$apiBaseUrl/logout");

        // Check if the response is successful
        if ($response->successful()) {
            // Forget the token in the session
            session()->forget(['bearer_token','role','permissions']);
            return redirect()->route('login_view')->with('success', 'Logged out successfully');
        } else {


            return redirect()->route('login_view')->with('error', 'Unable to logout');
        }
    }
}
