<?php

namespace App\Http\Controllers\Settings;

use App\DataTables\Settings\DesignationDataTable;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;

class DesignationController extends Controller
{
    private function fetch_departments(): array
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->get("{$apiBaseUrl}/departments");

        if ($response->successful()) {
            $departments = $response->json()['departments'] ?? [];
            // Extract only the necessary columns
            $departments = array_map(function ($departments) {
                return [
                    'id' => $departments['id'],
                    'department' => $departments['department'],
                ];
            }, $departments);

            return $departments;
        }

        return [];
    }
    public function designation_list(DesignationDataTable $dataTable)
    {
        $departments = $this->fetch_departments();
        return $dataTable->render('admin.settings.designation',compact('departments'));
    }
    public function add_designation_form(Request $request)
    {
        try {
            $token = session('bearer_token');
            $org_id = session('org_id');
            $apiBaseUrl = env('API_BASE_URL');
            $response = Http::withToken($token)->post("{$apiBaseUrl}/designations/store", [
                'department_id' => $request->department_id,
                'designation' => $request->designation,
                'org_id' => $org_id
            ]);
    
            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => 'Designation added successfully']);
            } else {
                $error = $response->json();
                return response()->json([
                    'success' => false,
                    'message' => $error['message'] ?? 'Failed to add Designation.'
                ], $response->status());
            }
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => 'Something went wrong: ' . $e->getMessage()], 500);
        }
    }
    public function update_designation_form(Request $request, $id)
    {
        try {
            // Get the token from session and set the base API URL
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
    
            // Send a PUT request to update the department
            $response = Http::withToken($token)->put("{$apiBaseUrl}/designations/update/{$id}", [
                'department_id' => $request->department_id,
                'designation' => $request->designation,
            ]);
    
            // Check if the response is successful
            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => 'Designation updated successfully']);
            } else {
                // If the response contains an error, extract the error message
                $error = $response->json();
                return response()->json([
                    'success' => false,
                    'message' => $error['message'] ?? 'Failed to update Designation.'
                ], $response->status());
            }
        } catch (\Exception $e) {
            // Handle general exceptions
            return response()->json(['success' => false, 'message' => 'Something went wrong: ' . $e->getMessage()], 500);
        }
    }
    
    
    public function delete_designation($id)
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->delete("{$apiBaseUrl}/designations/{$id}");
    
        if ($response->successful()) {
            return response()->json(['success' => true, 'message' => 'Designation deleted successfully']);
        } else {
            // Extract error message from the API response, defaulting to a generic message
            $error = $response->json();
            $errorMessage = $error['message'] ?? 'Unable to delete Designation';
            
            return response()->json([
                'success' => false,
                'message' => $errorMessage
            ], $response->status());
        }
    }
    

    public function get_designation($id)
    {
        try {
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
            $response = Http::withToken($token)->get("{$apiBaseUrl}/designations/get/{$id}");
    
          
    
            if ($response->successful()) {
                // Return the department data from the API response
                return response()->json($response->json()['designation']);
            } else {
                return response()->json(['status' => 404, 'message' => 'Designation not found.'], 404);
            }
        } catch (\Exception $e) {
            // Dump the exception message and die
            dd('An error occurred: ' . $e->getMessage());
            return response()->json(['message' => 'An error occurred: ' . $e->getMessage()], 500);
        }
    }
}
