<?php

namespace App\Http\Controllers\Settings;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use App\DataTables\Settings\ExpensesDataTable;
use App\DataTables\Settings\IncomeDataTable;

class IncomeExpenseController extends Controller
{
    public function expense_list(ExpensesDataTable $dataTable)
    {
        return $dataTable->render('admin.settings.expense');
    }
    public function add_expense_form(Request $request)
    {
        try {
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
            $org_id = session('org_id');
            $response = Http::withToken($token)->post("{$apiBaseUrl}/incomes/store", [
                'date' => $request->date,
                'description' => $request->description,
                'amount' => $request->amount,
                'status' => $request->status,  // assuming status should come from the request
                'type' => 'expense', // hardcoded as "expense"
                'org_id' => $org_id
            ]);

            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => 'Expense added successfully']);
            } else {
                $error = $response->json();
                return response()->json([
                    'success' => false,
                    'message' => $error['message'] ?? 'Failed to add expense.'
                ], $response->status());
            }
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => 'Something went wrong: ' . $e->getMessage()], 500);
        }
    }

    public function update_expense_form(Request $request, $id)
    {
        try {
            // Get the token from session and set the base API URL
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');

            // Send a PUT request to update the expense
            $response = Http::withToken($token)->put("{$apiBaseUrl}/incomes/update/{$id}", [
                'date' => $request->date,
                'description' => $request->description,
                'amount' => $request->amount,
                'status' => $request->status,  // assuming status should come from the request
                'type' => 'expense', // hardcoded as "expense"
            ]);

            // Check if the response is successful
            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => 'Expense updated successfully']);
            } else {
                // If the response contains an error, extract the error message
                $error = $response->json();
                return response()->json([
                    'success' => false,
                    'message' => $error['message'] ?? 'Failed to update Expense.'
                ], $response->status());
            }
        } catch (\Exception $e) {
            // Handle general exceptions
            return response()->json(['success' => false, 'message' => 'Something went wrong: ' . $e->getMessage()], 500);
        }
    }


    public function delete_expense($id)
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->delete("{$apiBaseUrl}/incomes/{$id}");

        if ($response->successful()) {
            return response()->json(['success' => true, 'message' => 'Expense deleted successfully']);
        } else {
            // Ensure the error message is correctly fetched from the API response
            $error = $response->json();
            return response()->json([
                'success' => false,
                'message' => $error['message'] ?? 'Unable to delete Expense'
            ], $response->status());
        }
    }

    public function get_expense($id)
    {
        try {
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
            $response = Http::withToken($token)->get("{$apiBaseUrl}/incomes/get/{$id}");



            if ($response->successful()) {
                // Return the expense data from the API response
                return response()->json($response->json()['income']);
            } else {
                return response()->json(['status' => 404, 'message' => 'Expense not found.'], 404);
            }
        } catch (\Exception $e) {
            // Dump the exception message and die
            dd('An error occurred: ' . $e->getMessage());
            return response()->json(['message' => 'An error occurred: ' . $e->getMessage()], 500);
        }
    }
    public function income_list(IncomeDataTable $dataTable)
    {
        return $dataTable->render('admin.settings.income');
    }
    public function add_income_form(Request $request)
    {
        try {
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
            $org_id = session('org_id');
            $response = Http::withToken($token)->post("{$apiBaseUrl}/incomes/store", [
                'date' => $request->date,
                'description' => $request->description,
                'amount' => $request->amount,
                'status' => $request->status,  // assuming status should come from the request
                'type' => 'income', // hardcoded as "expense"
                'org_id' => $org_id
            ]);

            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => 'Income added successfully']);
            } else {
                $error = $response->json();
                return response()->json([
                    'success' => false,
                    'message' => $error['message'] ?? 'Failed to add Income.'
                ], $response->status());
            }
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => 'Something went wrong: ' . $e->getMessage()], 500);
        }
    }

    public function update_income_form(Request $request, $id)
    {
        try {
            // Get the token from session and set the base API URL
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');

            // Send a PUT request to update the expense
            $response = Http::withToken($token)->put("{$apiBaseUrl}/incomes/update/{$id}", [
                'date' => $request->date,
                'description' => $request->description,
                'amount' => $request->amount,
                'status' => $request->status,  // assuming status should come from the request
                'type' => 'income', // hardcoded as "expense"
            ]);

            // Check if the response is successful
            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => 'Income updated successfully']);
            } else {
                // If the response contains an error, extract the error message
                $error = $response->json();
                return response()->json([
                    'success' => false,
                    'message' => $error['message'] ?? 'Failed to update Income.'
                ], $response->status());
            }
        } catch (\Exception $e) {
            // Handle general exceptions
            return response()->json(['success' => false, 'message' => 'Something went wrong: ' . $e->getMessage()], 500);
        }
    }
    public function delete_income($id)
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->delete("{$apiBaseUrl}/incomes/{$id}");

        if ($response->successful()) {
            return response()->json(['success' => true, 'message' => 'Income deleted successfully']);
        } else {
            // Ensure the error message is correctly fetched from the API response
            $error = $response->json();
            return response()->json([
                'success' => false,
                'message' => $error['message'] ?? 'Unable to delete Income'
            ], $response->status());
        }
    }
}
