<?php

namespace App\Http\Controllers\Settings;

use App\DataTables\Settings\LoanDataTable;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;

class LoanController extends Controller
{
    private function fetch_employees(): array
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->get("{$apiBaseUrl}/employees");
    
        if ($response->successful()) {
            // Fetch the employee data including related user name
            $employees = $response->json()['employees'] ?? [];
            
            // Extract only the employee ID and the associated user name
            $employees = array_map(function ($employee) {
                return [
                    'id' => $employee['id'], // Employee ID
                    'name' => $employee['user_profile']['user']['name'] ?? null, // Associated User's Name
                ];
            }, $employees);
    
            return $employees;
        }
    
        return [];
    }
    
    public function loan_list(LoanDataTable $dataTable)
    {
        $employees = $this->fetch_employees();
        return $dataTable->render('admin.settings.loan',compact('employees'));
    }
    public function add_loan_form(Request $request)
    {
       
        try {
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
            $org_id = session('org_id');
            $response = Http::withToken($token)->post("{$apiBaseUrl}/loans/store", [
                'employee_id' => $request->employee_id,
                'amount' => $request->amount,
                'date' => $request->date,
                'reason' => $request->reason,
                'status' => $request->status,
                'terms' => $request->terms,
                'installment' => $request->installment,
                'org_id' => $org_id
            ]);
          
    
            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => 'Loan added successfully']);
            } else {
                $error = $response->json();
                return response()->json([
                    'success' => false,
                    'message' => $error['message'] ?? 'Failed to add Loan.'
                ], $response->status());
            }
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => 'Something went wrong: ' . $e->getMessage()], 500);
        }
    }
    public function update_loan_form(Request $request, $id)
    {
        try {
            // Get the token from session and set the base API URL
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
    
            // Send a PUT request to update the education
            $response = Http::withToken($token)->put("{$apiBaseUrl}/loans/update/{$id}", [
                'employee_id' => $request->employee_id,
                'amount' => $request->amount,
                'date' => $request->date,
                'reason' => $request->reason,
                'status' => $request->status,
                'terms' => $request->terms,
                'installment' => $request->installment,
            ]);
    
            // Check if the response is successful
            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => 'Loan updated successfully']);
            } else {
                // If the response contains an error, extract the error message
                $error = $response->json();
                return response()->json([
                    'success' => false,
                    'message' => $error['message'] ?? 'Failed to update Loan.'
                ], $response->status());
            }
        } catch (\Exception $e) {
            // Handle general exceptions
            return response()->json(['success' => false, 'message' => 'Something went wrong: ' . $e->getMessage()], 500);
        }
    }
    
    
    public function delete_loan($id)
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->delete("{$apiBaseUrl}/loans/{$id}");

        if ($response->successful()) {
            return response()->json(['success' => true, 'message' => 'Loan deleted successfully']);
        } else {
            // Ensure the error message is correctly fetched from the API response
            $error = $response->json();
            return response()->json([
                'success' => false,
                'message' => $error['message'] ?? 'Unable to delete Loan'
            ], $response->status());
        }
    }

    public function get_loan($id)
    {
        try {
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
            $response = Http::withToken($token)->get("{$apiBaseUrl}/loans/get/{$id}");
    
          
    
            if ($response->successful()) {
                // Return the education data from the API response
              
                $loan = $response->json()['loan'][0];
                return response()->json($loan);
            } else {
                return response()->json(['status' => 404, 'message' => 'Loan not found.'], 404);
            }
        } catch (\Exception $e) {
            // Dump the exception message and die
            dd('An error occurred: ' . $e->getMessage());
            return response()->json(['message' => 'An error occurred: ' . $e->getMessage()], 500);
        }
    }
}
