<?php

namespace App\Http\Controllers\Settings;

use App\DataTables\Settings\ShiftDataTable;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;

class ShiftController extends Controller
{
    public function shift_list(ShiftDataTable $dataTable)
    {
        return $dataTable->render('admin.settings.shift');
    }
    public function add_shift_form(Request $request)
    {
       
        try {
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
            $org_id = session('org_id');
            $response = Http::withToken($token)->post("{$apiBaseUrl}/shift/store", [
                'shift' => $request->shift,
                'org_id' => $org_id
            ]);
    
            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => 'Shift added successfully']);
            } else {
                $error = $response->json();
                return response()->json([
                    'success' => false,
                    'message' => $error['message'] ?? 'Failed to add Shift.'
                ], $response->status());
            }
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => 'Something went wrong: ' . $e->getMessage()], 500);
        }
    }
    public function update_shift_form(Request $request, $id)
    {
        try {
            // Get the token from session and set the base API URL
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
    
            // Send a PUT request to update the education
            $response = Http::withToken($token)->put("{$apiBaseUrl}/shift/update/{$id}", [
                'shift' => $request->shift,
            ]);
    
            // Check if the response is successful
            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => 'Shift updated successfully']);
            } else {
                // If the response contains an error, extract the error message
                $error = $response->json();
                return response()->json([
                    'success' => false,
                    'message' => $error['message'] ?? 'Failed to update Shift.'
                ], $response->status());
            }
        } catch (\Exception $e) {
            // Handle general exceptions
            return response()->json(['success' => false, 'message' => 'Something went wrong: ' . $e->getMessage()], 500);
        }
    }
    
    
    public function delete_shift($id)
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->delete("{$apiBaseUrl}/shift/{$id}");

        if ($response->successful()) {
            return response()->json(['success' => true, 'message' => 'Shift deleted successfully']);
        } else {
            // Ensure the error message is correctly fetched from the API response
            $error = $response->json();
            return response()->json([
                'success' => false,
                'message' => $error['message'] ?? 'Unable to delete Shift'
            ], $response->status());
        }
    }

    public function get_shift($id)
    {
        try {
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
            $response = Http::withToken($token)->get("{$apiBaseUrl}/shift/get/{$id}");
    
          
    
            if ($response->successful()) {
                // Return the education data from the API response
                return response()->json($response->json()['shift']);
            } else {
                return response()->json(['status' => 404, 'message' => 'Shift not found.'], 404);
            }
        } catch (\Exception $e) {
            // Dump the exception message and die
            dd('An error occurred: ' . $e->getMessage());
            return response()->json(['message' => 'An error occurred: ' . $e->getMessage()], 500);
        }
    }
    
}
