<?php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Session;

class CheckPermission
{
    public function handle($request, Closure $next, $permission)
    {
        $userPermissions = session()->get('permissions', []);

        // Check if user has the required permission
        if (!in_array($permission, $userPermissions)) {
            abort(404);  // Show 404 page if permission is not found
        }

        return $next($request);
    }
}
