@extends('admin.layout.main')

@section('content')
    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    Increment List
                </h3>
                <nav class="col-md-6 text-right" aria-label="breadcrumb">
                    <button data-bs-toggle="modal" id="add_increment" class="btn btn-sm btn-outline-primary">
                        <i class="fa fa-plus-circle mr-sm-2"></i>Create Increment</button>
                </nav>
                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a
                                style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Increment List
                        </li>
                    </ol>
                </nav>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table id="increment_table" class="data_table table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Employee</th>
                                            <th>Amount</th>
                                            <th>Date</th>
                                            <th>Reason</th>
                                            <th>Status</th>
                                        
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>




    <div class="modal fade" id="createIncrement" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Add Increment</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="addIncrementForm" method="POST">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        @csrf
                        <label for="">Employee</label>
                        <select type="text" class="form-control" id="employee_id" name="employee_id"
                            placeholder="Enter Education" required>
                            <option selected disabled>Select Employe</option>
                            @foreach ($employees as $employee)
                                <option value="{{ $employee['id'] }}">{{ $employee['name'] }}</option>
                            @endforeach
                        </select>

                        <label class="mt-4">Amount</label>
                        <input class="form-control" type="number" id="amount" name="amount"
                            placeholder="Enter amount" required></input>

                        <label class="mt-4">Date</label>
                        <input class="form-control" type="date" id="date" name="date"
                            placeholder="Enter date" required></input>

                        

                        <label class="mt-4">Status</label>
                        <select type="text" class="form-control " id="status" name="status"
                            placeholder="Enter Education" required>
                            <option selected disabled>Select Status</option>
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>


                        <label class="mt-4">Reason</label>
                        <textarea class="form-control" type="text" id="reason" name="reason" rows="5" placeholder="Enter Reason"
                            required></textarea>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Add</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="updateIncrement" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Update Increment</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="updateIncrementForm">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        @csrf
                        <input type="hidden" name="increment_id" id="increment_id">

                        <label for="">Employee</label>
                        <select type="text" class="form-control" id="update_employee_id" name="employee_id"
                            placeholder="Enter Education" required>
                            <option selected disabled>Select Employe</option>
                            @foreach ($employees as $employee)
                                <option value="{{ $employee['id'] }}">{{ $employee['name'] }}</option>
                            @endforeach
                        </select>

                        <label class="mt-4">Amount</label>
                        <input class="form-control" type="number" id="update_amount" name="amount"
                            placeholder="Enter amount" required></input>

                        <label class="mt-4">Date</label>
                        <input class="form-control" type="date" id="update_date" name="date"
                            placeholder="Enter date" required></input>

                      

                        <label class=" mt-4">Status</label>
                        <select type="text" class="form-control" id="update_status" name="status"
                            placeholder="Enter Education" required>
                            <option selected disabled>Select Status</option>
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>


                        <label class="mt-4">Reson</label>
                        <textarea class="form-control" type="text" id="update_reason" name="reason" rows="5"
                            placeholder="Enter reason" required></textarea>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Update</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    @push('js')
        <script>
            $(document).ready(function() {
                $('#increment_table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: '{{ route('increment_list') }}',
                    columns: [{
                            data: 'id',
                            name: 'id'
                        },
                        {
                            data: 'employee_name',
                            name: 'employee_name'
                        },
                        {
                            data: 'amount',
                            name: 'amount'
                        },
                        {
                            data: 'date',
                            name: 'date',
                            render: function(data) {
                                return new Date(data).toLocaleDateString('en-GB', {
                                    day: '2-digit',
                                    month: 'short',
                                    year: 'numeric'
                                });
                            }
                        },

                        {
                            data: 'reason',
                            name: 'reason'
                        },
                        {
                            data: 'status',
                            name: 'status'
                        },
                       
                        
                        {
                            data: null,
                            name: 'action',
                            render: function(data, type, row) {
                                return `
                        <div class="dropdown">
                            <a style="font-size: 19px; color:black; text-decoration: none;" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                ⋮
                            </a>

                            <div class="dropdown-menu"  aria-labelledby="dropdownMenuLink" x-placement="bottom-start" style="position: absolute; transform: translate3d(0px, 21px, 0px); top: 0px; left: 0px; will-change: transform;">
                                <button data-id="${row.id}" id="editincrementtbtn"  class="dropdown-item text-primary">
                                    <i class="fa fa-pen mr-2"></i> Edit
                                </button>
                                <button data-id="${row.id}" id="delete_increment"  class="dropdown-item text-danger">
                                    <i class="far fa-trash-alt mr-2"></i> Delete
                                </button>
                            </div>
                        </div>
                    `;
                            }
                        }
                    ]
                });


                $('#add_increment').on('click', function() {
                    $('#createIncrement').modal('show');
                });
                $('#addIncrementForm').on('submit', function(e) {
                    e.preventDefault();

                    let $submitButton = $('#addIncrementForm button[type="submit"]');
                    $submitButton.prop('disabled', true);

                    $.ajax({
                        type: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('add_increment_form') }}",
                        data: $(this).serialize(),
                        success: function(response) {
                            if (response.success) {
                                $('#createIncrement').modal('hide');
                                $('#increment_table').DataTable().ajax.reload();
                                $('#addIncrementForm')[0].reset();
                                toastr.success(response.message);
                            } else {
                                let errorMessage = response.message;
                                if (response.errors) {
                                    errorMessage += '<br><br>Errors:<ul>';
                                    $.each(response.errors, function(key, errors) {
                                        $.each(errors, function(index, error) {
                                            errorMessage += '<li>' + error +
                                                '</li>';
                                        });
                                    });
                                    errorMessage += '</ul>';
                                }
                                toastr.error(errorMessage);
                            }
                        },
                        error: function(xhr) {
                            console.log("AJAX Error:", xhr);
                            toastr.error('Invalid Details '); // General error message
                        },
                        complete: function() {
                            $submitButton.prop('disabled', false);
                        }
                    });
                });
                $('body').on('click', '#delete_increment', function() {
                    var id = $(this).data('id');

                    $.ajax({
                        type: "DELETE",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('delete_increment', ['id' => ':id']) }}"
                            .replace(':id', id),
                        success: function(response) {
                            $('#increment_table').DataTable().ajax.reload();
                            // Show success Toastr message
                            toastr.success('Increment deleted successfully');
                        },
                        error: function(xhr) {
                            // Display error Toastr message
                            let errorMessage = 'An error occurred while deleting the Increment.';
                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorMessage = xhr.responseJSON.message;
                            }
                            toastr.error(errorMessage);
                        }
                    });
                });

                $('body').on('click', '#editincrementtbtn', function() {
                    var id = $(this).data('id');



                    $.ajax({
                        type: "GET",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('get_increment', ['id' => ':id']) }}"
                            .replace(':id', id),
                        success: function(response) {

                            if (response.status === 404) {
                                $('#updateIncrement').modal('hide');
                                toastr.error('Increment not found.');
                            } else {
                                $('#updateIncrement').modal('show');
                                var increment =
                                    response;
                                    console.log(increment) ;// response is already the department data
                                $('#increment_id').val(increment.id);
                                // $('#update_employee_id').val(increment.empoyee_id);
                                $('#update_amount').val(increment.amount);
                                $('#update_date').val(increment.date);
                                $('#update_status').val(increment.status);
                                $('#update_reason').val(increment.reason);
                            }
                        },
                        error: function(xhr) {

                            toastr.error('An error occurred while fetching the Increment.');
                        }
                    });
                });

                $('#updateIncrementForm').on('submit', function(e) {
                    e.preventDefault();

                    var id = $('#increment_id').val(); // Use the correct ID

                    // Disable the submit button to prevent multiple submissions
                    let $submitButton = $('#updateIncrementForm button[type="submit"]');
                    $submitButton.prop('disabled', true);

                    $.ajax({
                        type: 'PUT',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('update_increment_form', ['id' => ':id']) }}".replace(':id',
                            id),
                        data: $(this).serialize(),
                        success: function(response) {
                            console.log("AJAX Success:", response); // Log response for debugging

                            if (response.success) {
                                $('#updateIncrement').modal('hide');
                                $('#increment_table').DataTable().ajax
                                    .reload(); // Reload DataTable
                                toastr.success(response.message);
                                $('#updateIncrementForm')[0].reset();
                            } else {
                                // Handle validation or other errors
                                let errorMessage = response.message || 'An error occurred.';
                                toastr.error(errorMessage); // Display error
                            }
                        },
                        error: function(xhr) {
                            console.log("AJAX Error:", xhr); // Log the error for debugging
                            let errorMessage = 'An unexpected error occurred.';
                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorMessage = xhr.responseJSON.message;
                            }
                            toastr.error(errorMessage); // Display error
                        },
                        complete: function() {
                            // Re-enable the submit button after the request completes
                            $submitButton.prop('disabled', false);
                        }
                    });
                });

            });
        </script>
    @endpush
@endsection
