<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Settings\LoanController;
use App\Http\Controllers\Admin\EmployeeController;
use App\Http\Controllers\Settings\BonusController;
use App\Http\Controllers\Settings\ShiftController;
use App\Http\Controllers\Settings\SalaryController;
use App\Http\Controllers\Settings\JobTypeController;
use App\Http\Controllers\Settings\TaxSlabController;
use App\Http\Controllers\SuperAdmin\AdminController;
use App\Http\Controllers\Settings\DocumentController;
use App\Http\Controllers\Settings\AllowanceController;
use App\Http\Controllers\Settings\DeductionController;
use App\Http\Controllers\Settings\EducationController;
use App\Http\Controllers\Settings\IncrementController;
use App\Http\Controllers\Settings\DepartmentController;
use App\Http\Controllers\Settings\SalaryTypeController;
use App\Http\Controllers\Settings\DesignationController;
use App\Http\Controllers\Settings\InstallmentController;
use App\Http\Controllers\Settings\WorkHistoryController;
use App\Http\Controllers\Settings\IncomeExpenseController;
use App\Http\Controllers\SuperAdmin\OrganizationController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/


Route::middleware('guest')->group(function () {
    Route::get('/login', [AuthController::class, 'login_view'])->name('login_view');
    Route::post('/login', [AuthController::class, 'login'])->name('login');
});


// Authenticated routes
Route::middleware('check.token')->group(function () {
    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

    Route::get('/', function () {
        return view('admin.dashboard');
    });

    //employee
    Route::get('employee/create', [EmployeeController::class, 'create_employee'])->name('create_employee');
    Route::get('/employees', [EmployeeController::class, 'index'])->name('employees_index');
    Route::get('/employee_list', [EmployeeController::class, 'getEmployeeList'])->name('employee_list');
    Route::delete('employee/{id}', [EmployeeController::class, 'delete_employee'])->name('delete_employee');
    // Route for generating the salary slip
    Route::get('/generate_salary_slip', [EmployeeController::class, 'fetchPayslip'])->name('fetchPayslip');

    // Route for showing the salary slip after redirection
    Route::get('/salary_slip', [EmployeeController::class, 'showSalarySlip'])->name('salary_slip.show');

    //users
    Route::get('users', [UserController::class, 'user_list'])->name('user_list');
    Route::get('users/{id}', [UserController::class, 'get_user'])->name('get_user');
    Route::post('users/store', [UserController::class, 'add_user_form'])->name('add_user_form');
    Route::put('users/update/{id}', [UserController::class, 'update_user_form'])->name('update_user_form');
    Route::delete('users/{id}', [UserController::class, 'delete_user'])->name('delete_user');
   
   
    Route::get('manage_users', [AdminController::class, 'admin_list'])->name('admin_list');
    Route::get('manage_users/{id}', [AdminController::class, 'get_admin'])->name('get_admin');
    Route::post('manage_users/store', [AdminController::class, 'add_admin_form'])->name('add_admin_form');
    Route::put('manage_users/update/{id}', [AdminController::class, 'update_admin_form'])->name('update_admin_form');
    Route::delete('manage_users/{id}', [AdminController::class, 'delete_admin'])->name('delete_admin');


    //departments
    Route::get('departments', [DepartmentController::class, 'department_list'])->name('department_list');
    Route::get('department/{id}', [DepartmentController::class, 'get_department'])->name('get_department');
    Route::post('departments/store', [DepartmentController::class, 'add_department_form'])->name('add_department_form');
    Route::put('departments/update/{id}', [DepartmentController::class, 'update_department_form'])->name('update_department_form');
    Route::delete('departments/{id}', [DepartmentController::class, 'delete_department'])->name('delete_department');

    //designation
    Route::get('designations', [DesignationController::class, 'designation_list'])->name('designation_list');
    Route::get('designations/{id}', [DesignationController::class, 'get_designation'])->name('get_designation');
    Route::post('designations/store', [DesignationController::class, 'add_designation_form'])->name('add_designation_form');
    Route::put('designations/update/{id}', [DesignationController::class, 'update_designation_form'])->name('update_designation_form');
    Route::delete('designations/{id}', [DesignationController::class, 'delete_designation'])->name('delete_designation');

    //job_type
    Route::get('job_type', [JobTypeController::class, 'job_type_list'])->name('job_type_list');
    Route::get('job_type/{id}', [JobTypeController::class, 'get_job_type'])->name('get_job_type');
    Route::post('job_type/store', [JobTypeController::class, 'add_job_type_form'])->name('add_job_type_form');
    Route::put('job_type/update/{id}', [JobTypeController::class, 'update_job_type_form'])->name('update_job_type_form');
    Route::delete('job_type/{id}', [JobTypeController::class, 'delete_job_type'])->name('delete_job_type');


    //allowances
    Route::get('allowances', [AllowanceController::class, 'allowance_list'])->name('allowance_list');
    Route::get('allowances/{id}', [AllowanceController::class, 'get_allowance'])->name('get_allowance');
    Route::post('allowances/store', [AllowanceController::class, 'add_allowance_form'])->name('add_allowance_form');
    Route::put('allowances/update/{id}', [AllowanceController::class, 'update_allowance_form'])->name('update_allowance_form');
    Route::delete('allowances/{id}', [AllowanceController::class, 'delete_allowance'])->name('delete_allowance');

    //allowances
    Route::get('work_history', [WorkHistoryController::class, 'work_history_list'])->name('work_history_list');
    Route::get('work_history/{id}', [WorkHistoryController::class, 'get_work_history'])->name('get_work_history');
    Route::post('work_history/store', [WorkHistoryController::class, 'add_work_history_form'])->name('add_work_history_form');
    Route::put('work_history/update/{id}', [WorkHistoryController::class, 'update_work_history_form'])->name('update_work_history_form');
    Route::delete('work_history/{id}', [WorkHistoryController::class, 'delete_work_history'])->name('delete_work_history');

    //education
    Route::get('education', [EducationController::class, 'education_list'])->name('education_list');
    Route::get('education/{id}', [EducationController::class, 'get_education'])->name('get_education');
    Route::post('education/store', [EducationController::class, 'add_education_form'])->name('add_education_form');
    Route::put('education/update/{id}', [EducationController::class, 'update_education_form'])->name('update_education_form');
    Route::delete('education/{id}', [EducationController::class, 'delete_education'])->name('delete_education');

    //shift
    Route::get('shift', [ShiftController::class, 'shift_list'])->name('shift_list');
    Route::get('shift/{id}', [ShiftController::class, 'get_shift'])->name('get_shift');
    Route::post('shift/store', [ShiftController::class, 'add_shift_form'])->name('add_shift_form');
    Route::put('shift/update/{id}', [ShiftController::class, 'update_shift_form'])->name('update_shift_form');
    Route::delete('shift/{id}', [ShiftController::class, 'delete_shift'])->name('delete_shift');

    //salary
    Route::get('salary', [SalaryController::class, 'salary_list'])->name('salary_list');
    Route::get('salary/{id}', [SalaryController::class, 'get_salary'])->name('get_salary');
    Route::post('salary/store', [SalaryController::class, 'add_salary_form'])->name('add_salary_form');
    Route::put('salary/update/{id}', [SalaryController::class, 'update_salary_form'])->name('update_salary_form');
    Route::delete('salary/{id}', [SalaryController::class, 'delete_salary'])->name('delete_salary');

    //salary type
    Route::get('salary_type', [SalaryTypeController::class, 'salary_type_list'])->name('salary_type_list');
    Route::get('salary_type/{id}', [SalaryTypeController::class, 'get_salary_type'])->name('get_salary_type');
    Route::post('salary_type/store', [SalaryTypeController::class, 'add_salary_type_form'])->name('add_salary_type_form');
    Route::put('salary_type/update/{id}', [SalaryTypeController::class, 'update_salary_type_form'])->name('update_salary_type_form');
    Route::delete('salary_type/{id}', [SalaryTypeController::class, 'delete_salary_type'])->name('delete_salary_type');

    //increment
    Route::get('increment', [IncrementController::class, 'increment_list'])->name('increment_list');
    Route::get('increment/{id}', [IncrementController::class, 'get_increment'])->name('get_increment');
    Route::post('increment/store', [IncrementController::class, 'add_increment_form'])->name('add_increment_form');
    Route::put('increment/update/{id}', [IncrementController::class, 'update_increment_form'])->name('update_increment_form');
    Route::delete('increment/{id}', [IncrementController::class, 'delete_increment'])->name('delete_increment');

    //bonus
    Route::get('bonus', [BonusController::class, 'bonus_list'])->name('bonus_list');
    Route::get('bonus/{id}', [BonusController::class, 'get_bonus'])->name('get_bonus');
    Route::post('bonus/store', [BonusController::class, 'add_bonus_form'])->name('add_bonus_form');
    Route::put('bonus/update/{id}', [BonusController::class, 'update_bonus_form'])->name('update_bonus_form');
    Route::delete('bonus/{id}', [BonusController::class, 'delete_bonus'])->name('delete_bonus');

    //deduction
    Route::get('deduction', [DeductionController::class, 'deduction_list'])->name('deduction_list');
    Route::get('deduction/{id}', [DeductionController::class, 'get_deduction'])->name('get_deduction');
    Route::post('deduction/store', [DeductionController::class, 'add_deduction_form'])->name('add_deduction_form');
    Route::put('deduction/update/{id}', [DeductionController::class, 'update_deduction_form'])->name('update_deduction_form');
    Route::delete('deduction/{id}', [DeductionController::class, 'delete_deduction'])->name('delete_deduction');

    //text_slab
    Route::get('tax_slab', [TaxSlabController::class, 'tax_slab_list'])->name('tax_slab_list');
    Route::get('tax_slab/{id}', [TaxSlabController::class, 'get_tax_slab'])->name('get_tax_slab');
    Route::post('tax_slab/store', [TaxSlabController::class, 'add_tax_slab_form'])->name('add_tax_slab_form');
    Route::put('tax_slab/update/{id}', [TaxSlabController::class, 'update_tax_slab_form'])->name('update_tax_slab_form');
    Route::delete('tax_slab/{id}', [TaxSlabController::class, 'delete_tax_slab'])->name('delete_tax_slab');


    // //installment
    // Route::get('installment', [InstallmentController::class, 'installment_list'])->name('installment_list');
    // Route::get('installment/{id}', [InstallmentController::class, 'get_installment'])->name('get_installment');
    // Route::post('installment/store', [InstallmentController::class, 'add_installment_form'])->name('add_installment_form');
    // Route::put('installment/update/{id}', [InstallmentController::class, 'update_installment_form'])->name('update_installment_form');
    // Route::delete('installment/{id}', [InstallmentController::class, 'delete_installment'])->name('delete_installment');

    //loan
    Route::get('loan', [LoanController::class, 'loan_list'])->name('loan_list');
    Route::get('loan/{id}', [LoanController::class, 'get_loan'])->name('get_loan');
    Route::post('loan/store', [LoanController::class, 'add_loan_form'])->name('add_loan_form');
    Route::put('loan/update/{id}', [LoanController::class, 'update_loan_form'])->name('update_loan_form');
    Route::delete('loan/{id}', [LoanController::class, 'delete_loan'])->name('delete_loan');

    //expense
    Route::get('expense', [IncomeExpenseController::class, 'expense_list'])->name('expense_list');
    Route::get('expense/{id}', [IncomeExpenseController::class, 'get_expense'])->name('get_expense');
    Route::post('expense/store', [IncomeExpenseController::class, 'add_expense_form'])->name('add_expense_form');
    Route::put('expense/update/{id}', [IncomeExpenseController::class, 'update_expense_form'])->name('update_expense_form');
    Route::delete('expense/{id}', [IncomeExpenseController::class, 'delete_expense'])->name('delete_expense');

    //income
    Route::get('income', [IncomeExpenseController::class, 'income_list'])->name('income_list');
    Route::post('income/store', [IncomeExpenseController::class, 'add_income_form'])->name('add_income_form');
    Route::put('income/update/{id}', [IncomeExpenseController::class, 'update_income_form'])->name('update_income_form');
    Route::delete('income/{id}', [IncomeExpenseController::class, 'delete_income'])->name('delete_income');

    //expense
    Route::get('document', [DocumentController::class, 'document_list'])->name('document_list');
    Route::get('document/{id}', [DocumentController::class, 'get_document'])->name('get_document');
    Route::post('document/store', [DocumentController::class, 'add_document_form'])->name('add_document_form');
    Route::post('document/update/{id}', [DocumentController::class, 'update_document_form'])->name('update_document_form');
    Route::delete('document/{id}', [DocumentController::class, 'delete_document'])->name('delete_document');




    
    //organizations
    Route::get('organization', [OrganizationController::class, 'organization_list'])->name('organization_list');
    Route::get('organization/{id}', [OrganizationController::class, 'get_organization'])->name('get_organization');
    Route::post('organization/store', [OrganizationController::class, 'add_organization_form'])->name('add_organization_form');
    Route::put('organization/update/{id}', [OrganizationController::class, 'update_organization_form'])->name('update_organization_form');
    Route::delete('organization/{id}', [OrganizationController::class, 'delete_organization'])->name('delete_organization');

});
